/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.subscriber;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.SubscriptionStrategyEvaluator;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.BaseSubscriberForSubscriptionResources;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionCanonicalizer;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionConstants;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionRegistry;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscriptionChannelType;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.util.SubscriptionUtil;
import javax.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;

public class SubscriptionActivatingSubscriber
extends BaseSubscriberForSubscriptionResources
implements MessageHandler {
    private Logger ourLog = LoggerFactory.getLogger(SubscriptionActivatingSubscriber.class);
    @Autowired
    private SubscriptionRegistry mySubscriptionRegistry;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private SubscriptionCanonicalizer mySubscriptionCanonicalizer;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private SubscriptionStrategyEvaluator mySubscriptionStrategyEvaluator;

    public void handleMessage(@Nonnull Message<?> theMessage) throws MessagingException {
        if (!(theMessage instanceof ResourceModifiedJsonMessage)) {
            this.ourLog.warn("Received message of unexpected type on matching channel: {}", theMessage);
            return;
        }
        ResourceModifiedMessage payload = ((ResourceModifiedJsonMessage)theMessage).getPayload();
        if (!this.isSubscription(payload)) {
            return;
        }
        switch (payload.getOperationType()) {
            case CREATE: 
            case UPDATE: {
                this.activateOrRegisterSubscriptionIfRequired(payload.getNewPayload(this.myFhirContext));
                break;
            }
        }
    }

    public boolean activateOrRegisterSubscriptionIfRequired(IBaseResource theSubscription) {
        CanonicalSubscriptionChannelType subscriptionChannelType = this.mySubscriptionCanonicalizer.getChannelType(theSubscription);
        if (subscriptionChannelType == null || !this.myDaoConfig.getSupportedSubscriptionTypes().contains(subscriptionChannelType.toCanonical())) {
            return false;
        }
        String statusString = this.mySubscriptionCanonicalizer.getSubscriptionStatus(theSubscription);
        if (SubscriptionConstants.REQUESTED_STATUS.equals(statusString)) {
            return this.activateSubscription(theSubscription);
        }
        return false;
    }

    private boolean activateSubscription(IBaseResource theSubscription) {
        IFhirResourceDao subscriptionDao = this.myDaoRegistry.getSubscriptionDao();
        IBaseResource subscription = subscriptionDao.read(theSubscription.getIdElement());
        subscription.setId(subscription.getIdElement().toVersionless());
        this.ourLog.info("Activating subscription {} from status {} to {}", new Object[]{subscription.getIdElement().toUnqualified().getValue(), SubscriptionConstants.REQUESTED_STATUS, SubscriptionConstants.ACTIVE_STATUS});
        try {
            SubscriptionUtil.setStatus((FhirContext)this.myFhirContext, (IBaseResource)subscription, (String)SubscriptionConstants.ACTIVE_STATUS);
            subscriptionDao.update(subscription);
            return true;
        }
        catch (UnprocessableEntityException e) {
            this.ourLog.info("Changing status of {} to ERROR", (Object)subscription.getIdElement());
            SubscriptionUtil.setStatus((FhirContext)this.myFhirContext, (IBaseResource)subscription, (String)"error");
            SubscriptionUtil.setReason((FhirContext)this.myFhirContext, (IBaseResource)subscription, (String)e.getMessage());
            subscriptionDao.update(subscription);
            return false;
        }
    }
}

