/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.subscriber;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelRegistry;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.ISubscriptionMatcher;
import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionRegistry;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.rest.api.EncodingEnum;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;

public class SubscriptionMatchingSubscriber
implements MessageHandler {
    private Logger ourLog = LoggerFactory.getLogger(SubscriptionMatchingSubscriber.class);
    public static final String SUBSCRIPTION_MATCHING_CHANNEL_NAME = "subscription-matching";
    @Autowired
    private ISubscriptionMatcher mySubscriptionMatcher;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private SubscriptionRegistry mySubscriptionRegistry;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private SubscriptionChannelRegistry mySubscriptionChannelRegistry;

    public void handleMessage(@Nonnull Message<?> theMessage) throws MessagingException {
        this.ourLog.trace("Handling resource modified message: {}", theMessage);
        if (!(theMessage instanceof ResourceModifiedJsonMessage)) {
            this.ourLog.warn("Unexpected message payload type: {}", theMessage);
            return;
        }
        ResourceModifiedMessage msg = ((ResourceModifiedJsonMessage)theMessage).getPayload();
        this.matchActiveSubscriptionsAndDeliver(msg);
    }

    public void matchActiveSubscriptionsAndDeliver(ResourceModifiedMessage theMsg) {
        switch (theMsg.getOperationType()) {
            case CREATE: 
            case UPDATE: 
            case MANUALLY_TRIGGERED: {
                break;
            }
            default: {
                this.ourLog.trace("Not processing modified message for {}", (Object)theMsg.getOperationType());
                return;
            }
        }
        HookParams params = new HookParams().add(ResourceModifiedMessage.class, (Object)theMsg);
        if (!this.myInterceptorBroadcaster.callHooks(Pointcut.SUBSCRIPTION_BEFORE_PERSISTED_RESOURCE_CHECKED, params)) {
            return;
        }
        try {
            this.doMatchActiveSubscriptionsAndDeliver(theMsg);
        }
        finally {
            this.myInterceptorBroadcaster.callHooks(Pointcut.SUBSCRIPTION_AFTER_PERSISTED_RESOURCE_CHECKED, params);
        }
    }

    private void doMatchActiveSubscriptionsAndDeliver(ResourceModifiedMessage theMsg) {
        IIdType resourceId = theMsg.getId(this.myFhirContext);
        Collection<ActiveSubscription> subscriptions = this.mySubscriptionRegistry.getAll();
        this.ourLog.trace("Testing {} subscriptions for applicability", (Object)subscriptions.size());
        boolean resourceMatched = false;
        for (ActiveSubscription nextActiveSubscription : subscriptions) {
            InMemoryMatchResult matchResult;
            String nextSubscriptionId = this.getId(nextActiveSubscription);
            if (StringUtils.isNotBlank((CharSequence)theMsg.getSubscriptionId()) && !theMsg.getSubscriptionId().equals(nextSubscriptionId)) {
                this.ourLog.debug("Ignoring subscription {} because it is not {}", (Object)nextSubscriptionId, (Object)theMsg.getSubscriptionId());
                continue;
            }
            if (!this.validCriteria(nextActiveSubscription, resourceId) || !(matchResult = this.mySubscriptionMatcher.match(nextActiveSubscription.getSubscription(), theMsg)).matched()) continue;
            this.ourLog.debug("Subscription {} was matched by resource {} {}", new Object[]{nextActiveSubscription.getId(), resourceId.toUnqualifiedVersionless().getValue(), matchResult.isInMemory() ? "in-memory" : "by querying the repository"});
            IBaseResource payload = theMsg.getNewPayload(this.myFhirContext);
            CanonicalSubscription subscription = nextActiveSubscription.getSubscription();
            EncodingEnum encoding = null;
            if (subscription.getPayloadString() != null && !subscription.getPayloadString().isEmpty()) {
                encoding = EncodingEnum.forContentType((String)subscription.getPayloadString());
            }
            encoding = (EncodingEnum)ObjectUtils.defaultIfNull(encoding, (Object)EncodingEnum.JSON);
            ResourceDeliveryMessage deliveryMsg = new ResourceDeliveryMessage();
            deliveryMsg.setPayload(this.myFhirContext, payload, encoding);
            deliveryMsg.setSubscription(subscription);
            deliveryMsg.setOperationType(theMsg.getOperationType());
            deliveryMsg.copyAdditionalPropertiesFrom(theMsg);
            HookParams params = new HookParams().add(CanonicalSubscription.class, (Object)nextActiveSubscription.getSubscription()).add(ResourceDeliveryMessage.class, (Object)deliveryMsg).add(InMemoryMatchResult.class, (Object)matchResult);
            if (!this.myInterceptorBroadcaster.callHooks(Pointcut.SUBSCRIPTION_RESOURCE_MATCHED, params)) {
                return;
            }
            resourceMatched |= this.sendToDeliveryChannel(nextActiveSubscription, deliveryMsg);
        }
        if (!resourceMatched) {
            HookParams params = new HookParams().add(ResourceModifiedMessage.class, (Object)theMsg);
            this.myInterceptorBroadcaster.callHooks(Pointcut.SUBSCRIPTION_RESOURCE_DID_NOT_MATCH_ANY_SUBSCRIPTIONS, params);
        }
    }

    private boolean sendToDeliveryChannel(ActiveSubscription nextActiveSubscription, ResourceDeliveryMessage theDeliveryMsg) {
        boolean retVal = false;
        ResourceDeliveryJsonMessage wrappedMsg = new ResourceDeliveryJsonMessage(theDeliveryMsg);
        MessageChannel deliveryChannel = this.mySubscriptionChannelRegistry.getDeliverySenderChannel(nextActiveSubscription.getChannelName());
        if (deliveryChannel != null) {
            retVal = true;
            this.trySendToDeliveryChannel(wrappedMsg, deliveryChannel);
        } else {
            this.ourLog.warn("Do not have delivery channel for subscription {}", (Object)nextActiveSubscription.getId());
        }
        return retVal;
    }

    private void trySendToDeliveryChannel(ResourceDeliveryJsonMessage theWrappedMsg, MessageChannel theDeliveryChannel) {
        try {
            boolean success = theDeliveryChannel.send((Message)theWrappedMsg);
            if (!success) {
                this.ourLog.warn("Failed to send message to Delivery Channel.");
            }
        }
        catch (RuntimeException e) {
            this.ourLog.error("Failed to send message to Delivery Channel", (Throwable)e);
            throw new RuntimeException("Failed to send message to Delivery Channel", e);
        }
    }

    private String getId(ActiveSubscription theActiveSubscription) {
        return theActiveSubscription.getId();
    }

    private boolean validCriteria(ActiveSubscription theActiveSubscription, IIdType theResourceId) {
        String criteriaString = theActiveSubscription.getCriteriaString();
        String subscriptionId = this.getId(theActiveSubscription);
        String resourceType = theResourceId.getResourceType();
        if (StringUtils.isBlank((CharSequence)criteriaString)) {
            return false;
        }
        this.ourLog.trace("Checking subscription {} for {} with criteria {}", new Object[]{subscriptionId, resourceType, criteriaString});
        String criteriaResource = criteriaString;
        int index = criteriaResource.indexOf("?");
        if (index != -1) {
            criteriaResource = criteriaResource.substring(0, criteriaResource.indexOf("?"));
        }
        if (resourceType != null && !criteriaResource.equals(resourceType)) {
            this.ourLog.trace("Skipping subscription search for {} because it does not match the criteria {}", (Object)resourceType, (Object)criteriaString);
            return false;
        }
        return true;
    }
}

