/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.subscriber;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.BaseSubscriberForSubscriptionResources;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionCanonicalizer;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionRegistry;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import javax.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;

public class SubscriptionRegisteringSubscriber
extends BaseSubscriberForSubscriptionResources
implements MessageHandler {
    private Logger ourLog = LoggerFactory.getLogger(SubscriptionRegisteringSubscriber.class);
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private SubscriptionRegistry mySubscriptionRegistry;
    @Autowired
    private SubscriptionCanonicalizer mySubscriptionCanonicalizer;

    public void handleMessage(@Nonnull Message<?> theMessage) throws MessagingException {
        if (!(theMessage instanceof ResourceModifiedJsonMessage)) {
            this.ourLog.warn("Received message of unexpected type on matching channel: {}", theMessage);
            return;
        }
        ResourceModifiedMessage payload = ((ResourceModifiedJsonMessage)theMessage).getPayload();
        if (!this.isSubscription(payload)) {
            return;
        }
        switch (payload.getOperationType()) {
            case DELETE: {
                this.mySubscriptionRegistry.unregisterSubscriptionIfRegistered(payload.getId(this.myFhirContext).getIdPart());
                break;
            }
            case CREATE: 
            case UPDATE: {
                IBaseResource subscription = payload.getNewPayload(this.myFhirContext);
                String statusString = this.mySubscriptionCanonicalizer.getSubscriptionStatus(subscription);
                if ("active".equals(statusString)) {
                    this.mySubscriptionRegistry.registerSubscriptionUnlessAlreadyRegistered(payload.getNewPayload(this.myFhirContext));
                    break;
                }
                this.mySubscriptionRegistry.unregisterSubscriptionIfRegistered(payload.getId(this.myFhirContext).getIdPart());
                break;
            }
        }
    }
}

