/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.registry;

import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.model.sched.HapiJob;
import ca.uhn.fhir.jpa.model.sched.ISchedulerService;
import ca.uhn.fhir.jpa.model.sched.ScheduledJobDefinition;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.retry.Retrier;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionActivatingSubscriber;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionRegistry;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Semaphore;
import javax.annotation.PostConstruct;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Subscription;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SubscriptionLoader {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionLoader.class);
    private static final int MAX_RETRIES = 60;
    private final Object mySyncSubscriptionsLock = new Object();
    @Autowired
    private SubscriptionRegistry mySubscriptionRegistry;
    @Autowired(required=false)
    private DaoRegistry myDaoRegistry;
    private Semaphore mySyncSubscriptionsSemaphore = new Semaphore(1);
    @Autowired
    private ISchedulerService mySchedulerService;
    @Autowired
    private SubscriptionActivatingSubscriber mySubscriptionActivatingInterceptor;

    public void syncSubscriptions() {
        if (this.myDaoRegistry != null && !this.myDaoRegistry.isResourceTypeSupported("Subscription")) {
            return;
        }
        if (!this.mySyncSubscriptionsSemaphore.tryAcquire()) {
            return;
        }
        try {
            this.doSyncSubscriptionsWithRetry();
        }
        finally {
            this.mySyncSubscriptionsSemaphore.release();
        }
    }

    @PostConstruct
    public void scheduleJob() {
        ScheduledJobDefinition jobDetail = new ScheduledJobDefinition();
        jobDetail.setId(this.getClass().getName());
        jobDetail.setJobClass(Job.class);
        this.mySchedulerService.scheduleLocalJob(60000L, jobDetail);
        this.syncSubscriptions();
    }

    @VisibleForTesting
    public void acquireSemaphoreForUnitTest() throws InterruptedException {
        this.mySyncSubscriptionsSemaphore.acquire();
    }

    @VisibleForTesting
    public int doSyncSubscriptionsForUnitTest() {
        int first = this.doSyncSubscriptionsWithRetry();
        int second = this.doSyncSubscriptionsWithRetry();
        return first + second;
    }

    synchronized int doSyncSubscriptionsWithRetry() {
        Retrier syncSubscriptionRetrier = new Retrier(this::doSyncSubscriptions, 60);
        return (Integer)syncSubscriptionRetrier.runWithRetry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doSyncSubscriptions() {
        if (this.mySchedulerService.isStopping()) {
            return 0;
        }
        Object object = this.mySyncSubscriptionsLock;
        synchronized (object) {
            ourLog.debug("Starting sync subscriptions");
            SearchParameterMap map = new SearchParameterMap();
            map.add("status", (IQueryParameterOr)new TokenOrListParam().addOr(new TokenParam(null, Subscription.SubscriptionStatus.REQUESTED.toCode())).addOr(new TokenParam(null, Subscription.SubscriptionStatus.ACTIVE.toCode())));
            map.setLoadSynchronousUpTo(Integer.valueOf(50000));
            IFhirResourceDao subscriptionDao = this.myDaoRegistry.getSubscriptionDao();
            IBundleProvider subscriptionBundleList = subscriptionDao.search(map);
            Integer subscriptionCount = subscriptionBundleList.size();
            assert (subscriptionCount != null);
            if (subscriptionCount >= 50000) {
                ourLog.error("Currently over 50000 subscriptions.  Some subscriptions have not been loaded.");
            }
            List resourceList = subscriptionBundleList.getResources(0, subscriptionCount.intValue());
            HashSet<String> allIds = new HashSet<String>();
            int activatedCount = 0;
            int registeredCount = 0;
            for (IBaseResource resource : resourceList) {
                boolean registered;
                String nextId = resource.getIdElement().getIdPart();
                allIds.add(nextId);
                boolean activated = this.mySubscriptionActivatingInterceptor.activateOrRegisterSubscriptionIfRequired(resource);
                if (activated) {
                    ++activatedCount;
                }
                if (!(registered = this.mySubscriptionRegistry.registerSubscriptionUnlessAlreadyRegistered(resource))) continue;
                ++registeredCount;
            }
            this.mySubscriptionRegistry.unregisterAllSubscriptionsNotInCollection(allIds);
            ourLog.debug("Finished sync subscriptions - activated {} and registered {}", (Object)resourceList.size(), (Object)registeredCount);
            return activatedCount;
        }
    }

    public static class Job
    implements HapiJob {
        @Autowired
        private SubscriptionLoader myTarget;

        public void execute(JobExecutionContext theContext) {
            this.myTarget.syncSubscriptions();
        }
    }
}

