/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.model;

import ca.uhn.fhir.jpa.subscription.model.IResourceMessage;
import ca.uhn.fhir.model.api.IModelJson;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public abstract class BaseResourceMessage
implements IResourceMessage,
IModelJson {
    @JsonProperty(value="attributes")
    private Map<String, String> myAttributes;

    public Optional<String> getAttribute(String theKey) {
        Validate.notBlank((CharSequence)theKey);
        if (this.myAttributes == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.myAttributes.get(theKey));
    }

    public void setAttribute(String theKey, String theValue) {
        Validate.notBlank((CharSequence)theKey);
        Validate.notNull((Object)theValue);
        if (this.myAttributes == null) {
            this.myAttributes = new HashMap<String, String>();
        }
        this.myAttributes.put(theKey, theValue);
    }

    public void copyAdditionalPropertiesFrom(BaseResourceMessage theMsg) {
        if (theMsg.myAttributes != null) {
            if (this.myAttributes == null) {
                this.myAttributes = new HashMap<String, String>();
            }
            this.myAttributes.putAll(theMsg.myAttributes);
        }
    }
}

