/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.model;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu2.model.Subscription;
import org.hl7.fhir.exceptions.FHIRException;

public enum CanonicalSubscriptionChannelType {
    RESTHOOK,
    WEBSOCKET,
    EMAIL,
    SMS,
    MESSAGE,
    NULL;


    public String toCode() {
        switch (this) {
            case RESTHOOK: {
                return "rest-hook";
            }
            case WEBSOCKET: {
                return "websocket";
            }
            case EMAIL: {
                return "email";
            }
            case SMS: {
                return "sms";
            }
            case MESSAGE: {
                return "message";
            }
        }
        return "?";
    }

    public String getSystem() {
        switch (this) {
            case RESTHOOK: 
            case WEBSOCKET: 
            case EMAIL: 
            case SMS: 
            case MESSAGE: {
                return "http://terminology.hl7.org/CodeSystem/subscription-channel-type";
            }
        }
        return "?";
    }

    public String getDefinition() {
        switch (this) {
            case RESTHOOK: {
                return "The channel is executed by making a post to the URI. If a payload is included, the URL is interpreted as the service base, and an update (PUT) is made.";
            }
            case WEBSOCKET: {
                return "The channel is executed by sending a packet across a web socket connection maintained by the client. The URL identifies the websocket, and the client binds to this URL.";
            }
            case EMAIL: {
                return "The channel is executed by sending an email to the email addressed in the URI (which must be a mailto:).";
            }
            case SMS: {
                return "The channel is executed by sending an SMS message to the phone number identified in the URL (tel:).";
            }
            case MESSAGE: {
                return "The channel is executed by sending a message (e.g. a Bundle with a MessageHeader resource etc.) to the application identified in the URI.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case RESTHOOK: {
                return "Rest Hook";
            }
            case WEBSOCKET: {
                return "Websocket";
            }
            case EMAIL: {
                return "Email";
            }
            case SMS: {
                return "SMS";
            }
            case MESSAGE: {
                return "Message";
            }
        }
        return "?";
    }

    public Subscription.SubscriptionChannelType toCanonical() {
        return Subscription.SubscriptionChannelType.fromCode((String)this.toCode());
    }

    public static CanonicalSubscriptionChannelType fromCode(@Nullable String theSystem, @Nonnull String codeString) throws FHIRException {
        if (StringUtils.isBlank((CharSequence)codeString)) {
            return null;
        }
        if ("rest-hook".equals(codeString)) {
            if (theSystem == null || theSystem.equals("http://terminology.hl7.org/CodeSystem/subscription-channel-type")) {
                return RESTHOOK;
            }
        } else if ("websocket".equals(codeString)) {
            if (theSystem == null || theSystem.equals("http://terminology.hl7.org/CodeSystem/subscription-channel-type")) {
                return WEBSOCKET;
            }
        } else if ("email".equals(codeString)) {
            if (theSystem == null || theSystem.equals("http://terminology.hl7.org/CodeSystem/subscription-channel-type")) {
                return EMAIL;
            }
        } else if ("sms".equals(codeString)) {
            if (theSystem == null || theSystem.equals("http://terminology.hl7.org/CodeSystem/subscription-channel-type")) {
                return SMS;
            }
        } else if ("message".equals(codeString) && (theSystem == null || theSystem.equals("http://terminology.hl7.org/CodeSystem/subscription-channel-type"))) {
            return MESSAGE;
        }
        throw new FHIRException("Unknown SubscriptionChannelType code '" + codeString + "'");
    }
}

