/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.model;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.subscription.model.BaseResourceMessage;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.IResourceMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.rest.api.EncodingEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class ResourceDeliveryMessage
extends BaseResourceMessage
implements IResourceMessage {
    @JsonProperty(value="canonicalSubscription")
    private CanonicalSubscription mySubscription;
    @JsonProperty(value="payload")
    private String myPayloadString;
    @JsonIgnore
    private transient IBaseResource myPayload;
    @JsonProperty(value="payloadId")
    private String myPayloadId;
    @JsonProperty(value="operationType")
    private ResourceModifiedMessage.OperationTypeEnum myOperationType;

    public ResourceModifiedMessage.OperationTypeEnum getOperationType() {
        return this.myOperationType;
    }

    public void setOperationType(ResourceModifiedMessage.OperationTypeEnum theOperationType) {
        this.myOperationType = theOperationType;
    }

    public IBaseResource getPayload(FhirContext theCtx) {
        IBaseResource retVal = this.myPayload;
        if (retVal == null && StringUtils.isNotBlank((CharSequence)this.myPayloadString)) {
            this.myPayload = retVal = theCtx.newJsonParser().parseResource(this.myPayloadString);
        }
        return retVal;
    }

    public String getPayloadString() {
        if (this.myPayloadString != null) {
            return this.myPayloadString;
        }
        return "";
    }

    public IIdType getPayloadId(FhirContext theCtx) {
        IIdType retVal = null;
        if (this.myPayloadId != null) {
            retVal = theCtx.getVersion().newIdType().setValue(this.myPayloadId);
        }
        return retVal;
    }

    public CanonicalSubscription getSubscription() {
        return this.mySubscription;
    }

    public void setSubscription(CanonicalSubscription theSubscription) {
        this.mySubscription = theSubscription;
    }

    public void setPayload(FhirContext theCtx, IBaseResource thePayload, EncodingEnum theEncoding) {
        this.myPayload = thePayload;
        this.myPayloadString = theEncoding.newParser(theCtx).encodeResourceToString(thePayload);
        this.myPayloadId = thePayload.getIdElement().toUnqualified().getValue();
    }

    @Override
    public String getPayloadId() {
        return this.myPayloadId;
    }

    public void setPayloadId(IIdType thePayloadId) {
        this.myPayloadId = null;
        if (thePayloadId != null) {
            this.myPayloadId = thePayloadId.getValue();
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("mySubscription", (Object)this.mySubscription).append("myPayloadString", (Object)this.myPayloadString).append("myPayload", (Object)this.myPayload).append("myPayloadId", (Object)this.myPayloadId).append("myOperationType", (Object)this.myOperationType).toString();
    }

    public String getSubscriptionId(FhirContext theFhirContext) {
        IIdType idElement;
        String retVal = null;
        if (this.getSubscription() != null && (idElement = this.getSubscription().getIdElement(theFhirContext)) != null) {
            retVal = idElement.getValue();
        }
        return retVal;
    }
}

