/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.model;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.subscription.model.BaseResourceMessage;
import ca.uhn.fhir.jpa.subscription.model.IResourceMessage;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class ResourceModifiedMessage
extends BaseResourceMessage
implements IResourceMessage,
IModelJson {
    @JsonProperty(value="resourceId")
    private String myId;
    @JsonProperty(value="operationType")
    private OperationTypeEnum myOperationType;
    @JsonProperty(value="subscriptionId", required=false)
    private String mySubscriptionId;
    @JsonProperty(value="payload")
    private String myPayload;
    @JsonProperty(value="payloadId")
    private String myPayloadId;
    @JsonIgnore
    private transient IBaseResource myPayloadDecoded;

    public ResourceModifiedMessage() {
    }

    public ResourceModifiedMessage(FhirContext theFhirContext, IBaseResource theResource, OperationTypeEnum theOperationType) {
        this();
        this.setId(theResource.getIdElement());
        this.setOperationType(theOperationType);
        if (theOperationType != OperationTypeEnum.DELETE) {
            this.setNewPayload(theFhirContext, theResource);
        }
    }

    @Override
    public String getPayloadId() {
        return this.myPayloadId;
    }

    public String getSubscriptionId() {
        return this.mySubscriptionId;
    }

    public void setSubscriptionId(String theSubscriptionId) {
        this.mySubscriptionId = theSubscriptionId;
    }

    public String getId() {
        return this.myId;
    }

    public IIdType getId(FhirContext theCtx) {
        IIdType retVal = null;
        if (this.myId != null) {
            retVal = theCtx.getVersion().newIdType().setValue(this.myId);
        }
        return retVal;
    }

    public IBaseResource getNewPayload(FhirContext theCtx) {
        if (this.myPayloadDecoded == null && StringUtils.isNotBlank((CharSequence)this.myPayload)) {
            this.myPayloadDecoded = theCtx.newJsonParser().parseResource(this.myPayload);
        }
        return this.myPayloadDecoded;
    }

    public OperationTypeEnum getOperationType() {
        return this.myOperationType;
    }

    public void setOperationType(OperationTypeEnum theOperationType) {
        this.myOperationType = theOperationType;
    }

    public void setId(IIdType theId) {
        this.myId = null;
        if (theId != null) {
            this.myId = theId.getValue();
        }
    }

    private void setNewPayload(FhirContext theCtx, IBaseResource theNewPayload) {
        assert (ResourceModifiedMessage.payloadContainsNoPlaceholderReferences(theCtx, theNewPayload));
        this.myPayload = theCtx.newJsonParser().encodeResourceToString(theNewPayload);
        this.myPayloadId = theNewPayload.getIdElement().toUnqualified().getValue();
    }

    private static boolean payloadContainsNoPlaceholderReferences(FhirContext theCtx, IBaseResource theNewPayload) {
        List refs = theCtx.newTerser().getAllResourceReferences(theNewPayload);
        for (ResourceReferenceInfo next : refs) {
            IBaseResource resource;
            String ref = next.getResourceReference().getReferenceElement().getValue();
            if (StringUtils.isBlank((CharSequence)ref) && (resource = next.getResourceReference().getResource()) != null) {
                ref = resource.getIdElement().getValue();
            }
            if (StringUtils.isNotBlank((CharSequence)ref) && !ref.startsWith("#") && ref.startsWith("urn:uuid:")) {
                throw new AssertionError((Object)("Reference at " + next.getName() + " is invalid: " + ref));
            }
        }
        return true;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("myId", (Object)this.myId).append("myOperationType", (Object)this.myOperationType).append("mySubscriptionId", (Object)this.mySubscriptionId).append("myPayloadId", (Object)this.myPayloadId).toString();
    }

    public static enum OperationTypeEnum {
        CREATE,
        UPDATE,
        DELETE,
        MANUALLY_TRIGGERED;

    }
}

