/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.submit.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.subscription.channel.impl.LinkedBlockingChannel;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelFactory;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.IResourceModifiedConsumer;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.jpa.util.JpaInterceptorBroadcaster;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Interceptor
public class SubscriptionMatcherInterceptor
implements IResourceModifiedConsumer {
    private Logger ourLog = LoggerFactory.getLogger(SubscriptionMatcherInterceptor.class);
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private SubscriptionChannelFactory mySubscriptionChannelFactory;
    private volatile MessageChannel myMatchingChannel;

    @EventListener(classes={ContextRefreshedEvent.class})
    public void startIfNeeded() {
        if (this.myMatchingChannel == null) {
            this.myMatchingChannel = this.mySubscriptionChannelFactory.newMatchingSendingChannel("subscription-matching", null);
        }
    }

    @Hook(value=Pointcut.STORAGE_PRECOMMIT_RESOURCE_CREATED)
    public void resourceCreated(IBaseResource theResource, RequestDetails theRequest) {
        this.startIfNeeded();
        this.submitResourceModified(theResource, ResourceModifiedMessage.OperationTypeEnum.CREATE, theRequest);
    }

    @Hook(value=Pointcut.STORAGE_PRECOMMIT_RESOURCE_DELETED)
    public void resourceDeleted(IBaseResource theResource, RequestDetails theRequest) {
        this.startIfNeeded();
        this.submitResourceModified(theResource, ResourceModifiedMessage.OperationTypeEnum.DELETE, theRequest);
    }

    @Hook(value=Pointcut.STORAGE_PRECOMMIT_RESOURCE_UPDATED)
    public void resourceUpdated(IBaseResource theOldResource, IBaseResource theNewResource, RequestDetails theRequest) {
        this.startIfNeeded();
        this.submitResourceModified(theNewResource, ResourceModifiedMessage.OperationTypeEnum.UPDATE, theRequest);
    }

    @Override
    public void submitResourceModified(IBaseResource theNewResource, ResourceModifiedMessage.OperationTypeEnum theOperationType, RequestDetails theRequest) {
        ResourceModifiedMessage msg = new ResourceModifiedMessage(this.myFhirContext, theNewResource, theOperationType);
        HookParams params = new HookParams().add(ResourceModifiedMessage.class, (Object)msg);
        boolean outcome = JpaInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.SUBSCRIPTION_RESOURCE_MODIFIED, (HookParams)params);
        if (!outcome) {
            return;
        }
        this.submitResourceModified(msg);
    }

    @Override
    public void submitResourceModified(final ResourceModifiedMessage theMsg) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public int getOrder() {
                    return 0;
                }

                public void afterCommit() {
                    SubscriptionMatcherInterceptor.this.sendToProcessingChannel(theMsg);
                }
            });
        } else {
            this.sendToProcessingChannel(theMsg);
        }
    }

    protected void sendToProcessingChannel(ResourceModifiedMessage theMessage) {
        this.ourLog.trace("Sending resource modified message to processing channel");
        Validate.notNull((Object)this.myMatchingChannel, (String)"A SubscriptionMatcherInterceptor has been registered without calling start() on it.", (Object[])new Object[0]);
        this.myMatchingChannel.send((Message)new ResourceModifiedJsonMessage(theMessage));
    }

    public void setFhirContext(FhirContext theCtx) {
        this.myFhirContext = theCtx;
    }

    @VisibleForTesting
    public LinkedBlockingChannel getProcessingChannelForUnitTest() {
        return (LinkedBlockingChannel)this.myMatchingChannel;
    }
}

