/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.submit.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.SubscriptionMatchingStrategy;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.SubscriptionStrategyEvaluator;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionCanonicalizer;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscriptionChannelType;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Autowired;

@Interceptor
public class SubscriptionValidatingInterceptor {
    @Autowired
    private SubscriptionCanonicalizer mySubscriptionCanonicalizer;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private SubscriptionStrategyEvaluator mySubscriptionStrategyEvaluator;
    @Autowired
    private FhirContext myFhirContext;

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED)
    public void resourcePreCreate(IBaseResource theResource) {
        this.validateSubmittedSubscription(theResource);
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED)
    public void resourcePreCreate(IBaseResource theOldResource, IBaseResource theResource) {
        this.validateSubmittedSubscription(theResource);
    }

    @VisibleForTesting
    public void setFhirContextForUnitTest(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    public void validateSubmittedSubscription(IBaseResource theSubscription) {
        if (!"Subscription".equals(this.myFhirContext.getResourceDefinition(theSubscription).getName())) {
            return;
        }
        CanonicalSubscription subscription = this.mySubscriptionCanonicalizer.canonicalize(theSubscription);
        boolean finished = false;
        if (subscription.getStatus() == null) {
            throw new UnprocessableEntityException("Can not process submitted Subscription - Subscription.status must be populated on this server");
        }
        switch (subscription.getStatus()) {
            case REQUESTED: 
            case ACTIVE: {
                break;
            }
            case ERROR: 
            case OFF: 
            case NULL: {
                finished = true;
            }
        }
        this.mySubscriptionCanonicalizer.setMatchingStrategyTag(theSubscription, null);
        if (!finished) {
            String query = subscription.getCriteriaString();
            if (StringUtils.isBlank((CharSequence)query)) {
                throw new UnprocessableEntityException("Subscription.criteria must be populated");
            }
            int sep = query.indexOf(63);
            if (sep <= 1) {
                throw new UnprocessableEntityException("Subscription.criteria must be in the form \"{Resource Type}?[params]\"");
            }
            String resType = query.substring(0, sep);
            if (resType.contains("/")) {
                throw new UnprocessableEntityException("Subscription.criteria must be in the form \"{Resource Type}?[params]\"");
            }
            this.validateChannelType(subscription);
            if (!this.myDaoRegistry.isResourceTypeSupported(resType)) {
                throw new UnprocessableEntityException("Subscription.criteria contains invalid/unsupported resource type: " + resType);
            }
            try {
                SubscriptionMatchingStrategy strategy = this.mySubscriptionStrategyEvaluator.determineStrategy(query);
                this.mySubscriptionCanonicalizer.setMatchingStrategyTag(theSubscription, strategy);
            }
            catch (DataFormatException | InvalidRequestException e) {
                throw new UnprocessableEntityException("Invalid subscription criteria submitted: " + query + " " + e.getMessage());
            }
            if (subscription.getChannelType() == null) {
                throw new UnprocessableEntityException("Subscription.channel.type must be populated on this server");
            }
        }
    }

    protected void validateChannelType(CanonicalSubscription theSubscription) {
        if (theSubscription.getChannelType() == null) {
            throw new UnprocessableEntityException("Subscription.channel.type must be populated");
        }
        if (theSubscription.getChannelType() == CanonicalSubscriptionChannelType.RESTHOOK) {
            this.validateChannelPayload(theSubscription);
            this.validateChannelEndpoint(theSubscription);
        }
    }

    protected void validateChannelEndpoint(CanonicalSubscription theResource) {
        if (StringUtils.isBlank((CharSequence)theResource.getEndpointUrl())) {
            throw new UnprocessableEntityException("Rest-hook subscriptions must have Subscription.channel.endpoint defined");
        }
    }

    protected void validateChannelPayload(CanonicalSubscription theResource) {
        if (!StringUtils.isBlank((CharSequence)theResource.getPayloadString()) && EncodingEnum.forContentType((String)theResource.getPayloadString()) == null) {
            throw new UnprocessableEntityException("Invalid value for Subscription.channel.payload: " + theResource.getPayloadString());
        }
    }

    @VisibleForTesting
    public void setSubscriptionCanonicalizerForUnitTest(SubscriptionCanonicalizer theSubscriptionCanonicalizer) {
        this.mySubscriptionCanonicalizer = theSubscriptionCanonicalizer;
    }

    @VisibleForTesting
    public void setDaoRegistryForUnitTest(DaoRegistry theDaoRegistry) {
        this.myDaoRegistry = theDaoRegistry;
    }

    @VisibleForTesting
    public void setSubscriptionStrategyEvaluatorForUnitTest(SubscriptionStrategyEvaluator theSubscriptionStrategyEvaluator) {
        this.mySubscriptionStrategyEvaluator = theSubscriptionStrategyEvaluator;
    }
}

