/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.util;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscriptionChannelType;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.util.StopWatch;
import java.util.Date;
import java.util.EnumMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@Interceptor
public class SubscriptionDebugLogInterceptor {
    private static final String SUBSCRIPTION_DEBUG_LOG_INTERCEPTOR_PRECHECK = "SubscriptionDebugLogInterceptor_precheck";
    private final Level myLevel;
    private final EnumMap<EventCodeEnum, Logger> myLoggers;

    public SubscriptionDebugLogInterceptor() {
        this(SubscriptionDebugLogInterceptor.defaultLogFactory(), Level.INFO);
    }

    public SubscriptionDebugLogInterceptor(Function<EventCodeEnum, Logger> theLogFactory, Level theLevel) {
        this.myLevel = theLevel;
        this.myLoggers = new EnumMap(EventCodeEnum.class);
        for (EventCodeEnum next : EventCodeEnum.values()) {
            this.myLoggers.put(next, theLogFactory.apply(next));
        }
    }

    @Hook(value=Pointcut.SUBSCRIPTION_RESOURCE_MODIFIED)
    public void step10_resourceModified(ResourceModifiedMessage theMessage) {
        String value = Long.toString(System.currentTimeMillis());
        theMessage.setAttribute(SUBSCRIPTION_DEBUG_LOG_INTERCEPTOR_PRECHECK, value);
        String resourceId = theMessage.getPayloadId();
        if (resourceId == null) {
            resourceId = theMessage.getId();
        }
        this.log(EventCodeEnum.SUBS1, "Resource {} was submitted to the processing pipeline (op={})", new Object[]{resourceId, theMessage.getOperationType()});
    }

    @Hook(value=Pointcut.SUBSCRIPTION_BEFORE_PERSISTED_RESOURCE_CHECKED)
    public void step20_beforeChecked(ResourceModifiedMessage theMessage) {
        this.log(EventCodeEnum.SUBS2, "Checking resource {} (op={}) for matching subscriptions", new Object[]{theMessage.getPayloadId(), theMessage.getOperationType()});
    }

    @Hook(value=Pointcut.SUBSCRIPTION_RESOURCE_MATCHED)
    public void step30_subscriptionMatched(ResourceDeliveryMessage theMessage, InMemoryMatchResult theResult) {
        this.log(EventCodeEnum.SUBS3, "Resource {} matched by subscription {} (memory match={})", theMessage.getPayloadId(), theMessage.getSubscription().getIdElementString(), theResult.isInMemory());
    }

    @Hook(value=Pointcut.SUBSCRIPTION_RESOURCE_DID_NOT_MATCH_ANY_SUBSCRIPTIONS)
    public void step35_subscriptionNotMatched(ResourceModifiedMessage theMessage) {
        this.log(EventCodeEnum.SUBS4, "Resource {} did not match any subscriptions", theMessage.getPayloadId());
    }

    @Hook(value=Pointcut.SUBSCRIPTION_BEFORE_DELIVERY)
    public void step40_beforeDelivery(ResourceDeliveryMessage theMessage) {
        this.log(EventCodeEnum.SUBS5, "Delivering resource {} for subscription {} to channel of type {} to endpoint {}", new Object[]{theMessage.getPayloadId(), theMessage.getSubscription().getIdElementString(), theMessage.getSubscription().getChannelType(), theMessage.getSubscription().getEndpointUrl()});
    }

    @Hook(value=Pointcut.SUBSCRIPTION_AFTER_DELIVERY_FAILED)
    public void step45_deliveryFailed(ResourceDeliveryMessage theMessage, Exception theFailure) {
        String payloadId = null;
        String subscriptionId = null;
        CanonicalSubscriptionChannelType channelType = null;
        String failureString = null;
        if (theMessage != null) {
            payloadId = theMessage.getPayloadId();
            if (theMessage.getSubscription() != null) {
                subscriptionId = theMessage.getSubscription().getIdElementString();
                channelType = theMessage.getSubscription().getChannelType();
            }
        }
        if (theFailure != null) {
            failureString = theFailure.toString();
        }
        this.log(EventCodeEnum.SUBS6, "Delivery of resource {} for subscription {} to channel of type {} - Failure: {}", new Object[]{payloadId, subscriptionId, channelType, failureString});
    }

    @Hook(value=Pointcut.SUBSCRIPTION_AFTER_DELIVERY)
    public void step50_afterDelivery(ResourceDeliveryMessage theMessage) {
        String processingTime = theMessage.getAttribute(SUBSCRIPTION_DEBUG_LOG_INTERCEPTOR_PRECHECK).map(Long::parseLong).map(Date::new).map(start -> new StopWatch(start).toString()).orElse("(unknown)");
        this.log(EventCodeEnum.SUBS7, "Finished delivery of resource {} for subscription {} to channel of type {} - Total processing time: {}", new Object[]{theMessage.getPayloadId(), theMessage.getSubscription().getIdElementString(), theMessage.getSubscription().getChannelType(), processingTime});
    }

    protected void log(EventCodeEnum theEventCode, String theMessage, Object ... theArguments) {
        Logger logger = this.myLoggers.get((Object)theEventCode);
        if (logger != null) {
            switch (this.myLevel) {
                case ERROR: {
                    logger.error(theMessage, theArguments);
                    break;
                }
                case WARN: {
                    logger.warn(theMessage, theArguments);
                    break;
                }
                case INFO: {
                    logger.info(theMessage, theArguments);
                    break;
                }
                case DEBUG: {
                    logger.debug(theMessage, theArguments);
                    break;
                }
                case TRACE: {
                    logger.trace(theMessage, theArguments);
                }
            }
        }
    }

    private static Function<EventCodeEnum, Logger> defaultLogFactory() {
        return code -> LoggerFactory.getLogger((String)(SubscriptionDebugLogInterceptor.class.getName() + "." + code.name()));
    }

    public static enum EventCodeEnum {
        SUBS1,
        SUBS2,
        SUBS3,
        SUBS4,
        SUBS5,
        SUBS6,
        SUBS7;

    }
}

