/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.subscription;

import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelWithHandlers;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubscriptionChannelCache {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionRegistry.class);
    private final Map<String, SubscriptionChannelWithHandlers> myCache = new ConcurrentHashMap<String, SubscriptionChannelWithHandlers>();

    SubscriptionChannelCache() {
    }

    public SubscriptionChannelWithHandlers get(String theChannelName) {
        return this.myCache.get(theChannelName);
    }

    public int size() {
        return this.myCache.size();
    }

    public void put(String theChannelName, SubscriptionChannelWithHandlers theValue) {
        this.myCache.put(theChannelName, theValue);
    }

    synchronized void closeAndRemove(String theChannelName) {
        Validate.notBlank((CharSequence)theChannelName);
        SubscriptionChannelWithHandlers subscriptionChannelWithHandlers = this.myCache.get(theChannelName);
        if (subscriptionChannelWithHandlers == null) {
            return;
        }
        subscriptionChannelWithHandlers.close();
        this.myCache.remove(theChannelName);
    }

    public boolean containsKey(String theChannelName) {
        return this.myCache.containsKey(theChannelName);
    }

    void logForUnitTest() {
        for (String key : this.myCache.keySet()) {
            ourLog.info("SubscriptionChannelCache: {}", (Object)key);
        }
    }
}

