/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.subscription;

import ca.uhn.fhir.jpa.subscription.match.deliver.email.IEmailSender;
import ca.uhn.fhir.jpa.subscription.match.deliver.email.SubscriptionDeliveringEmailSubscriber;
import ca.uhn.fhir.jpa.subscription.match.deliver.message.SubscriptionDeliveringMessageSubscriber;
import ca.uhn.fhir.jpa.subscription.match.deliver.resthook.SubscriptionDeliveringRestHookSubscriber;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscriptionChannelType;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.messaging.MessageHandler;

public class SubscriptionDeliveryHandlerFactory {
    private IEmailSender myEmailSender;
    @Autowired
    private ApplicationContext myApplicationContext;

    protected SubscriptionDeliveringEmailSubscriber newSubscriptionDeliveringEmailSubscriber(IEmailSender theEmailSender) {
        return (SubscriptionDeliveringEmailSubscriber)this.myApplicationContext.getBean(SubscriptionDeliveringEmailSubscriber.class, new Object[]{theEmailSender});
    }

    protected SubscriptionDeliveringRestHookSubscriber newSubscriptionDeliveringRestHookSubscriber() {
        return (SubscriptionDeliveringRestHookSubscriber)this.myApplicationContext.getBean(SubscriptionDeliveringRestHookSubscriber.class);
    }

    protected SubscriptionDeliveringMessageSubscriber newSubscriptionDeliveringMessageSubscriber() {
        return (SubscriptionDeliveringMessageSubscriber)this.myApplicationContext.getBean(SubscriptionDeliveringMessageSubscriber.class);
    }

    public Optional<MessageHandler> createDeliveryHandler(CanonicalSubscriptionChannelType theChannelType) {
        if (theChannelType == CanonicalSubscriptionChannelType.EMAIL) {
            return Optional.of(this.newSubscriptionDeliveringEmailSubscriber(this.myEmailSender));
        }
        if (theChannelType == CanonicalSubscriptionChannelType.RESTHOOK) {
            return Optional.of(this.newSubscriptionDeliveringRestHookSubscriber());
        }
        if (theChannelType == CanonicalSubscriptionChannelType.MESSAGE) {
            return Optional.of(this.newSubscriptionDeliveringMessageSubscriber());
        }
        return Optional.empty();
    }

    public void setEmailSender(IEmailSender theEmailSender) {
        this.myEmailSender = theEmailSender;
    }
}

