/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.deliver;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionRegistry;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage;
import ca.uhn.fhir.jpa.subscription.util.SubscriptionUtil;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.util.BundleBuilder;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import org.apache.commons.text.StringSubstitutor;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;

public abstract class BaseSubscriptionDeliverySubscriber
implements MessageHandler {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseSubscriptionDeliverySubscriber.class);
    @Autowired
    protected FhirContext myFhirContext;
    @Autowired
    protected SubscriptionRegistry mySubscriptionRegistry;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private MatchUrlService myMatchUrlService;

    public void handleMessage(Message theMessage) throws MessagingException {
        if (!(theMessage.getPayload() instanceof ResourceDeliveryMessage)) {
            ourLog.warn("Unexpected payload type: {}", theMessage.getPayload());
            return;
        }
        ResourceDeliveryMessage msg = (ResourceDeliveryMessage)theMessage.getPayload();
        String subscriptionId = msg.getSubscriptionId(this.myFhirContext);
        if (subscriptionId == null) {
            ourLog.warn("Subscription has no ID, ignoring");
            return;
        }
        ActiveSubscription updatedSubscription = this.mySubscriptionRegistry.get(msg.getSubscription().getIdElement(this.myFhirContext).getIdPart());
        if (updatedSubscription != null) {
            msg.setSubscription(updatedSubscription.getSubscription());
        }
        try {
            HookParams params = new HookParams().add(ResourceDeliveryMessage.class, (Object)msg).add(CanonicalSubscription.class, (Object)msg.getSubscription());
            if (!this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.SUBSCRIPTION_BEFORE_DELIVERY, params)) {
                return;
            }
            this.handleMessage(msg);
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.SUBSCRIPTION_AFTER_DELIVERY, params);
        }
        catch (Exception e) {
            String errorMsg = "Failure handling subscription payload for subscription: " + subscriptionId;
            ourLog.error(errorMsg, (Throwable)e);
            HookParams hookParams = new HookParams().add(ResourceDeliveryMessage.class, (Object)msg).add(Exception.class, (Object)e);
            if (!this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.SUBSCRIPTION_AFTER_DELIVERY_FAILED, hookParams)) {
                return;
            }
            throw new MessagingException(Msg.code((int)2) + errorMsg, (Throwable)e);
        }
    }

    public abstract void handleMessage(ResourceDeliveryMessage var1) throws Exception;

    protected IBaseBundle createDeliveryBundleForPayloadSearchCriteria(CanonicalSubscription theSubscription, IBaseResource thePayloadResource) {
        String resType = theSubscription.getPayloadSearchCriteria().substring(0, theSubscription.getPayloadSearchCriteria().indexOf(63));
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resType);
        RuntimeResourceDefinition resourceDefinition = this.myFhirContext.getResourceDefinition(resType);
        String payloadUrl = theSubscription.getPayloadSearchCriteria();
        HashMap<String, String> valueMap = new HashMap<String, String>(1);
        valueMap.put("matched_resource_id", thePayloadResource.getIdElement().toUnqualifiedVersionless().getValue());
        payloadUrl = new StringSubstitutor(valueMap).replace(payloadUrl);
        SearchParameterMap payloadSearchMap = this.myMatchUrlService.translateMatchUrl(payloadUrl, resourceDefinition, new MatchUrlService.Flag[]{MatchUrlService.processIncludes()});
        payloadSearchMap.setLoadSynchronous(true);
        IBundleProvider searchResults = dao.search(payloadSearchMap, SubscriptionUtil.createRequestDetailForPartitionedRequest(theSubscription));
        BundleBuilder builder = new BundleBuilder(this.myFhirContext);
        for (IBaseResource next : searchResults.getAllResources()) {
            builder.addTransactionUpdateEntry(next);
        }
        return builder.getBundle();
    }

    @VisibleForTesting
    public void setFhirContextForUnitTest(FhirContext theCtx) {
        this.myFhirContext = theCtx;
    }

    @VisibleForTesting
    public void setInterceptorBroadcasterForUnitTest(IInterceptorBroadcaster theInterceptorBroadcaster) {
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
    }

    @VisibleForTesting
    public void setSubscriptionRegistryForUnitTest(SubscriptionRegistry theSubscriptionRegistry) {
        this.mySubscriptionRegistry = theSubscriptionRegistry;
    }

    @VisibleForTesting
    public void setDaoRegistryForUnitTest(DaoRegistry theDaoRegistry) {
        this.myDaoRegistry = theDaoRegistry;
    }

    @VisibleForTesting
    public void setMatchUrlServiceForUnitTest(MatchUrlService theMatchUrlService) {
        this.myMatchUrlService = theMatchUrlService;
    }

    public IInterceptorBroadcaster getInterceptorBroadcaster() {
        return this.myInterceptorBroadcaster;
    }
}

