/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.deliver.email;

import ca.uhn.fhir.jpa.subscription.match.deliver.email.EmailDetails;
import ca.uhn.fhir.jpa.subscription.match.deliver.email.IEmailSender;
import ca.uhn.fhir.rest.server.mail.IMailSvc;
import ca.uhn.fhir.util.StopWatch;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;
import org.simplejavamail.api.email.Email;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailSenderImpl
implements IEmailSender {
    private static final Logger ourLog = LoggerFactory.getLogger(EmailSenderImpl.class);
    private final IMailSvc myMailSvc;

    public EmailSenderImpl(@Nonnull IMailSvc theMailSvc) {
        Validate.notNull((Object)theMailSvc);
        this.myMailSvc = theMailSvc;
    }

    @Override
    public void send(EmailDetails theDetails) {
        StopWatch stopWatch = new StopWatch();
        ourLog.info("Sending email for subscription {} from [{}] to recipients: [{}]", new Object[]{theDetails.getSubscriptionId(), theDetails.getFrom(), theDetails.getTo()});
        Email email = theDetails.toEmail();
        this.myMailSvc.sendMail(email, () -> ourLog.info("Done sending email for subscription {} from [{}] to recipients: [{}] (took {}ms)", new Object[]{theDetails.getSubscriptionId(), theDetails.getFrom(), theDetails.getTo(), stopWatch.getMillis()}), e -> {
            ourLog.error("Error sending email for subscription {} from [{}] to recipients: [{}] (took {}ms)", new Object[]{theDetails.getSubscriptionId(), theDetails.getFrom(), theDetails.getTo(), stopWatch.getMillis()});
            ourLog.error("Error sending email", (Throwable)e);
        });
    }
}

