/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.deliver.email;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import ca.uhn.fhir.jpa.subscription.match.deliver.BaseSubscriptionDeliverySubscriber;
import ca.uhn.fhir.jpa.subscription.match.deliver.email.EmailDetails;
import ca.uhn.fhir.jpa.subscription.match.deliver.email.IEmailSender;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage;
import ca.uhn.fhir.rest.api.EncodingEnum;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SubscriptionDeliveringEmailSubscriber
extends BaseSubscriptionDeliverySubscriber {
    private Logger ourLog = LoggerFactory.getLogger(SubscriptionDeliveringEmailSubscriber.class);
    @Autowired
    private ModelConfig myModelConfig;
    @Autowired
    private FhirContext myCtx;
    private IEmailSender myEmailSender;

    @Autowired
    public SubscriptionDeliveringEmailSubscriber(IEmailSender theEmailSender) {
        this.myEmailSender = theEmailSender;
    }

    @Override
    public void handleMessage(ResourceDeliveryMessage theMessage) throws Exception {
        EncodingEnum encoding;
        String[] destinationAddressStrings;
        CanonicalSubscription subscription = theMessage.getSubscription();
        String endpointUrl = subscription.getEndpointUrl();
        ArrayList<String> destinationAddresses = new ArrayList<String>();
        for (String next : destinationAddressStrings = StringUtils.split((String)endpointUrl, (String)",")) {
            if (!StringUtils.isNotBlank((CharSequence)(next = this.processEmailAddressUri(next)))) continue;
            destinationAddresses.add(next);
        }
        String payload = "";
        if (StringUtils.isNotBlank((CharSequence)subscription.getPayloadString()) && (encoding = EncodingEnum.forContentType((String)subscription.getPayloadString())) != null) {
            payload = theMessage.getPayloadString();
        }
        String from = this.processEmailAddressUri(StringUtils.defaultString((String)subscription.getEmailDetails().getFrom(), (String)this.myModelConfig.getEmailFromAddress()));
        String subjectTemplate = StringUtils.defaultString((String)subscription.getEmailDetails().getSubjectTemplate(), (String)this.provideDefaultSubjectTemplate());
        EmailDetails details = new EmailDetails();
        details.setTo(destinationAddresses);
        details.setFrom(from);
        details.setBodyTemplate(payload);
        details.setSubjectTemplate(subjectTemplate);
        details.setSubscription(subscription.getIdElement(this.myFhirContext));
        this.myEmailSender.send(details);
    }

    private String processEmailAddressUri(String next) {
        if ((next = StringUtils.trim((String)StringUtils.defaultString((String)next))).startsWith("mailto:")) {
            next = next.substring("mailto:".length());
        }
        return next;
    }

    private String provideDefaultSubjectTemplate() {
        return "HAPI FHIR Subscriptions";
    }

    public void setEmailSender(IEmailSender theEmailSender) {
        this.myEmailSender = theEmailSender;
    }
}

