/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.deliver.message;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.subscription.channel.api.ChannelProducerSettings;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelFactory;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelProducer;
import ca.uhn.fhir.jpa.subscription.match.deliver.BaseSubscriptionDeliverySubscriber;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.rest.api.EncodingEnum;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;

@Scope(value="prototype")
public class SubscriptionDeliveringMessageSubscriber
extends BaseSubscriptionDeliverySubscriber {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionDeliveringMessageSubscriber.class);
    private final IChannelFactory myChannelFactory;

    public SubscriptionDeliveringMessageSubscriber(IChannelFactory theChannelFactory) {
        this.myChannelFactory = theChannelFactory;
    }

    protected void doDelivery(ResourceDeliveryMessage theSourceMessage, CanonicalSubscription theSubscription, IChannelProducer theChannelProducer, ResourceModifiedJsonMessage theWrappedMessageToSend) {
        String payloadId = theSourceMessage.getPayloadId();
        if (StringUtils.isNotBlank((CharSequence)theSubscription.getPayloadSearchCriteria())) {
            IBaseBundle payloadResource = this.createDeliveryBundleForPayloadSearchCriteria(theSubscription, theWrappedMessageToSend.getPayload().getPayload(this.myFhirContext));
            ResourceModifiedJsonMessage newWrappedMessageToSend = this.convertDeliveryMessageToResourceModifiedMessage(theSourceMessage, (IBaseResource)payloadResource);
            theWrappedMessageToSend.setPayload(newWrappedMessageToSend.getPayload());
            payloadId = payloadResource.getIdElement().toUnqualifiedVersionless().getValue();
        }
        theChannelProducer.send((Message)theWrappedMessageToSend);
        ourLog.debug("Delivering {} message payload {} for {}", new Object[]{theSourceMessage.getOperationType(), payloadId, theSubscription.getIdElement(this.myFhirContext).toUnqualifiedVersionless().getValue()});
    }

    private ResourceModifiedJsonMessage convertDeliveryMessageToResourceModifiedMessage(ResourceDeliveryMessage theMsg, IBaseResource thePayloadResource) {
        ResourceModifiedMessage payload = new ResourceModifiedMessage(this.myFhirContext, thePayloadResource, theMsg.getOperationType());
        payload.setMessageKey(theMsg.getMessageKeyOrNull());
        payload.setTransactionId(theMsg.getTransactionId());
        payload.setPartitionId(theMsg.getRequestPartitionId());
        return new ResourceModifiedJsonMessage(payload);
    }

    @Override
    public void handleMessage(ResourceDeliveryMessage theMessage) throws MessagingException, URISyntaxException {
        CanonicalSubscription subscription = theMessage.getSubscription();
        IBaseResource payloadResource = theMessage.getPayload(this.myFhirContext);
        ResourceModifiedJsonMessage messageWrapperToSend = this.convertDeliveryMessageToResourceModifiedMessage(theMessage, payloadResource);
        HookParams params = new HookParams().add(CanonicalSubscription.class, (Object)subscription).add(ResourceDeliveryMessage.class, (Object)theMessage).add(ResourceModifiedJsonMessage.class, (Object)messageWrapperToSend);
        if (!this.getInterceptorBroadcaster().callHooks((IPointcut)Pointcut.SUBSCRIPTION_BEFORE_MESSAGE_DELIVERY, params)) {
            return;
        }
        String endpointUrl = subscription.getEndpointUrl();
        String queueName = this.extractQueueNameFromEndpoint(endpointUrl);
        ChannelProducerSettings channelSettings = new ChannelProducerSettings();
        channelSettings.setQualifyChannelName(false);
        IChannelProducer channelProducer = this.myChannelFactory.getOrCreateProducer(queueName, ResourceModifiedJsonMessage.class, channelSettings);
        String payloadString = subscription.getPayloadString();
        EncodingEnum payloadType = null;
        if (payloadString != null) {
            payloadType = EncodingEnum.forContentType((String)payloadString);
        }
        if (payloadType != EncodingEnum.JSON) {
            throw new UnsupportedOperationException(Msg.code((int)4) + "Only JSON payload type is currently supported for Message Subscriptions");
        }
        this.doDelivery(theMessage, subscription, channelProducer, messageWrapperToSend);
        params = new HookParams().add(CanonicalSubscription.class, (Object)subscription).add(ResourceDeliveryMessage.class, (Object)theMessage);
        if (!this.getInterceptorBroadcaster().callHooks((IPointcut)Pointcut.SUBSCRIPTION_AFTER_MESSAGE_DELIVERY, params)) {
            return;
        }
    }

    private String extractQueueNameFromEndpoint(String theEndpointUrl) throws URISyntaxException {
        URI uri = new URI(theEndpointUrl);
        return uri.getSchemeSpecificPart();
    }
}

