/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.deliver.resthook;

import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.subscription.match.deliver.BaseSubscriptionDeliverySubscriber;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.client.api.Header;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import ca.uhn.fhir.rest.client.api.ServerValidationModeEnum;
import ca.uhn.fhir.rest.client.interceptor.SimpleRequestHeaderInterceptor;
import ca.uhn.fhir.rest.gclient.IClientExecutable;
import ca.uhn.fhir.rest.gclient.IUpdateTyped;
import ca.uhn.fhir.rest.server.exceptions.ResourceGoneException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.messaging.BaseResourceMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.messaging.MessagingException;

@Scope(value="prototype")
public class SubscriptionDeliveringRestHookSubscriber
extends BaseSubscriptionDeliverySubscriber {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionDeliveringRestHookSubscriber.class);
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private MatchUrlService myMatchUrlService;

    protected void deliverPayload(ResourceDeliveryMessage theMsg, CanonicalSubscription theSubscription, EncodingEnum thePayloadType, IGenericClient theClient) {
        IBaseResource payloadResource = this.getAndMassagePayload(theMsg, theSubscription);
        this.doDelivery(theMsg, theSubscription, thePayloadType, theClient, payloadResource);
    }

    protected void doDelivery(ResourceDeliveryMessage theMsg, CanonicalSubscription theSubscription, EncodingEnum thePayloadType, IGenericClient theClient, IBaseResource thePayloadResource) {
        IClientExecutable<?, ?> operation;
        if (StringUtils.isNotBlank((CharSequence)theSubscription.getPayloadSearchCriteria())) {
            operation = this.createDeliveryRequestTransaction(theSubscription, theClient, thePayloadResource);
        } else if (thePayloadType != null) {
            operation = this.createDeliveryRequestNormal(theMsg, theClient, thePayloadResource);
        } else {
            this.sendNotification(theMsg);
            operation = null;
        }
        if (operation != null) {
            if (thePayloadType != null) {
                operation.encoded(thePayloadType);
            }
            String payloadId = thePayloadResource.getIdElement().toUnqualified().getValue();
            ourLog.info("Delivering {} rest-hook payload {} for {}", new Object[]{theMsg.getOperationType(), payloadId, theSubscription.getIdElement(this.myFhirContext).toUnqualifiedVersionless().getValue()});
            try {
                operation.execute();
            }
            catch (ResourceNotFoundException e) {
                ourLog.error("Cannot reach {} ", (Object)theMsg.getSubscription().getEndpointUrl());
                ourLog.error("Exception: ", (Throwable)e);
                throw e;
            }
        }
    }

    @Nullable
    private IClientExecutable<?, ?> createDeliveryRequestNormal(ResourceDeliveryMessage theMsg, IGenericClient theClient, IBaseResource thePayloadResource) {
        IUpdateTyped operation;
        switch (theMsg.getOperationType()) {
            case CREATE: 
            case UPDATE: {
                operation = theClient.update().resource(thePayloadResource);
                break;
            }
            case DELETE: {
                operation = theClient.delete().resourceById(theMsg.getPayloadId(this.myFhirContext));
                break;
            }
            default: {
                ourLog.warn("Ignoring delivery message of type: {}", (Object)theMsg.getOperationType());
                operation = null;
            }
        }
        return operation;
    }

    private IClientExecutable<?, ?> createDeliveryRequestTransaction(CanonicalSubscription theSubscription, IGenericClient theClient, IBaseResource thePayloadResource) {
        IBaseBundle bundle = this.createDeliveryBundleForPayloadSearchCriteria(theSubscription, thePayloadResource);
        return theClient.transaction().withBundle(bundle);
    }

    public IBaseResource getResource(IIdType payloadId, RequestPartitionId thePartitionId, boolean theDeletedOK) throws ResourceGoneException {
        RuntimeResourceDefinition resourceDef = this.myFhirContext.getResourceDefinition(payloadId.getResourceType());
        SystemRequestDetails systemRequestDetails = new SystemRequestDetails().setRequestPartitionId(thePartitionId);
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceDef.getImplementingClass());
        return dao.read(payloadId.toVersionless(), (RequestDetails)systemRequestDetails, theDeletedOK);
    }

    protected IBaseResource getAndMassagePayload(ResourceDeliveryMessage theMsg, CanonicalSubscription theSubscription) {
        IBaseResource payloadResource = theMsg.getPayload(this.myFhirContext);
        if (payloadResource == null || theSubscription.getRestHookDetails().isDeliverLatestVersion()) {
            IIdType payloadId = theMsg.getPayloadId(this.myFhirContext);
            try {
                if (payloadId == null) {
                    return null;
                }
                boolean deletedOK = theMsg.getOperationType() == BaseResourceMessage.OperationTypeEnum.DELETE;
                payloadResource = this.getResource(payloadId.toVersionless(), theMsg.getRequestPartitionId(), deletedOK);
            }
            catch (ResourceGoneException e) {
                ourLog.warn("Resource {} is deleted, not going to deliver for subscription {}", (Object)payloadId.toVersionless(), (Object)theSubscription.getIdElement(this.myFhirContext));
                return null;
            }
        }
        IIdType resourceId = payloadResource.getIdElement();
        if (theSubscription.getRestHookDetails().isStripVersionId()) {
            resourceId = resourceId.toVersionless();
            payloadResource.setId(resourceId);
        }
        return payloadResource;
    }

    @Override
    public void handleMessage(ResourceDeliveryMessage theMessage) throws MessagingException {
        CanonicalSubscription subscription = theMessage.getSubscription();
        HookParams params = new HookParams().add(CanonicalSubscription.class, (Object)subscription).add(ResourceDeliveryMessage.class, (Object)theMessage);
        if (!this.getInterceptorBroadcaster().callHooks((IPointcut)Pointcut.SUBSCRIPTION_BEFORE_REST_HOOK_DELIVERY, params)) {
            return;
        }
        String endpointUrl = subscription.getEndpointUrl();
        String payloadString = subscription.getPayloadString();
        EncodingEnum payloadType = null;
        if (payloadString != null) {
            payloadType = EncodingEnum.forContentType((String)payloadString);
        }
        this.myFhirContext.getRestfulClientFactory().setServerValidationMode(ServerValidationModeEnum.NEVER);
        IGenericClient client = null;
        if (StringUtils.isNotBlank((CharSequence)endpointUrl)) {
            client = this.myFhirContext.newRestfulGenericClient(endpointUrl);
            List headers = subscription.getHeaders();
            for (String next : headers) {
                if (!StringUtils.isNotBlank((CharSequence)next)) continue;
                client.registerInterceptor((Object)new SimpleRequestHeaderInterceptor(next));
            }
        }
        this.deliverPayload(theMessage, subscription, payloadType, client);
        params = new HookParams().add(CanonicalSubscription.class, (Object)subscription).add(ResourceDeliveryMessage.class, (Object)theMessage);
        if (!this.getInterceptorBroadcaster().callHooks((IPointcut)Pointcut.SUBSCRIPTION_AFTER_REST_HOOK_DELIVERY, params)) {
            return;
        }
    }

    protected void sendNotification(ResourceDeliveryMessage theMsg) {
        HashMap params = new HashMap();
        CanonicalSubscription subscription = theMsg.getSubscription();
        List<Header> headers = SubscriptionDeliveringRestHookSubscriber.parseHeadersFromSubscription(subscription);
        StringBuilder url = new StringBuilder(subscription.getEndpointUrl());
        IHttpClient client = this.myFhirContext.getRestfulClientFactory().getHttpClient(url, params, "", RequestTypeEnum.POST, headers);
        IHttpRequest request = client.createParamRequest(this.myFhirContext, params, null);
        try {
            IHttpResponse response = request.execute();
            response.close();
        }
        catch (IOException e) {
            ourLog.error("Error trying to reach {}: {}", (Object)theMsg.getSubscription().getEndpointUrl(), (Object)e.toString());
            throw new ResourceNotFoundException(Msg.code((int)5) + e.getMessage());
        }
    }

    public static List<Header> parseHeadersFromSubscription(CanonicalSubscription subscription) {
        List<Object> headers = null;
        if (subscription != null) {
            for (String h : subscription.getHeaders()) {
                int sep;
                if (h == null || (sep = h.indexOf(58)) <= 0) continue;
                String name = h.substring(0, sep);
                String value = h.substring(sep + 1);
                if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                if (headers == null) {
                    headers = new ArrayList<Header>();
                }
                headers.add(new Header(name.trim(), value.trim()));
            }
        }
        headers = headers == null ? Collections.emptyList() : Collections.unmodifiableList(headers);
        return headers;
    }
}

