/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.matching;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.searchparam.matcher.SearchParamMatcher;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.ISubscriptionMatcher;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class InMemorySubscriptionMatcher
implements ISubscriptionMatcher {
    private static final Logger ourLog = LoggerFactory.getLogger(InMemorySubscriptionMatcher.class);
    @Autowired
    private FhirContext myContext;
    @Autowired
    private SearchParamMatcher mySearchParamMatcher;

    @Override
    public InMemoryMatchResult match(CanonicalSubscription theSubscription, ResourceModifiedMessage theMsg) {
        try {
            return this.mySearchParamMatcher.match(theSubscription.getCriteriaString(), theMsg.getNewPayload(this.myContext), null);
        }
        catch (Exception e) {
            ourLog.error("Failure in in-memory matcher", (Throwable)e);
            throw new InternalErrorException(Msg.code((int)1) + "Failure performing memory-match for resource ID[" + theMsg.getPayloadId(this.myContext) + "] for subscription ID[" + theSubscription.getIdElementString() + "]: " + e.getMessage(), (Throwable)e);
        }
    }
}

