/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.subscriber;

import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.subscription.channel.api.ChannelConsumerSettings;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelReceiver;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelFactory;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionActivatingSubscriber;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionMatchingSubscriber;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionRegisteringSubscriber;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.messaging.MessageHandler;

public class MatchingQueueSubscriberLoader {
    protected IChannelReceiver myMatchingChannel;
    private Logger ourLog = LoggerFactory.getLogger(MatchingQueueSubscriberLoader.class);
    @Autowired
    private SubscriptionMatchingSubscriber mySubscriptionMatchingSubscriber;
    @Autowired
    private SubscriptionChannelFactory mySubscriptionChannelFactory;
    @Autowired
    private SubscriptionRegisteringSubscriber mySubscriptionRegisteringSubscriber;
    @Autowired
    private SubscriptionActivatingSubscriber mySubscriptionActivatingSubscriber;
    @Autowired
    private DaoConfig myDaoConfig;

    @EventListener(value={ContextRefreshedEvent.class})
    @Order(value=300)
    public void subscribeToMatchingChannel() {
        if (this.myMatchingChannel == null) {
            this.myMatchingChannel = this.mySubscriptionChannelFactory.newMatchingReceivingChannel("subscription-matching", this.getChannelConsumerSettings());
        }
        if (this.myMatchingChannel != null) {
            this.myMatchingChannel.subscribe((MessageHandler)this.mySubscriptionMatchingSubscriber);
            this.myMatchingChannel.subscribe((MessageHandler)this.mySubscriptionActivatingSubscriber);
            this.myMatchingChannel.subscribe((MessageHandler)this.mySubscriptionRegisteringSubscriber);
            this.ourLog.info("Subscription Matching Subscriber subscribed to Matching Channel {} with name {}", (Object)this.myMatchingChannel.getClass().getName(), (Object)"subscription-matching");
        }
    }

    private ChannelConsumerSettings getChannelConsumerSettings() {
        ChannelConsumerSettings channelConsumerSettings = new ChannelConsumerSettings();
        channelConsumerSettings.setQualifyChannelName(this.myDaoConfig.isQualifySubscriptionMatchingChannelName());
        return channelConsumerSettings;
    }

    @PreDestroy
    public void stop() throws Exception {
        if (this.myMatchingChannel != null) {
            this.ourLog.info("Destroying matching Channel {} with name {}", (Object)this.myMatchingChannel.getClass().getName(), (Object)"subscription-matching");
            this.myMatchingChannel.destroy();
            this.myMatchingChannel.unsubscribe((MessageHandler)this.mySubscriptionMatchingSubscriber);
            this.myMatchingChannel.unsubscribe((MessageHandler)this.mySubscriptionActivatingSubscriber);
            this.myMatchingChannel.unsubscribe((MessageHandler)this.mySubscriptionRegisteringSubscriber);
        }
    }
}

