/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.subscriber;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelRegistry;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.ISubscriptionMatcher;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionCriteriaParser;
import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionRegistry;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.server.messaging.BaseResourceMessage;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;

public class SubscriptionMatchingSubscriber
implements MessageHandler {
    private final Logger ourLog = LoggerFactory.getLogger(SubscriptionMatchingSubscriber.class);
    public static final String SUBSCRIPTION_MATCHING_CHANNEL_NAME = "subscription-matching";
    @Autowired
    private ISubscriptionMatcher mySubscriptionMatcher;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private SubscriptionRegistry mySubscriptionRegistry;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private SubscriptionChannelRegistry mySubscriptionChannelRegistry;

    public void handleMessage(@Nonnull Message<?> theMessage) throws MessagingException {
        this.ourLog.trace("Handling resource modified message: {}", theMessage);
        if (!(theMessage instanceof ResourceModifiedJsonMessage)) {
            this.ourLog.warn("Unexpected message payload type: {}", theMessage);
            return;
        }
        ResourceModifiedMessage msg = ((ResourceModifiedJsonMessage)theMessage).getPayload();
        this.matchActiveSubscriptionsAndDeliver(msg);
    }

    public void matchActiveSubscriptionsAndDeliver(ResourceModifiedMessage theMsg) {
        switch (theMsg.getOperationType()) {
            case CREATE: 
            case UPDATE: 
            case MANUALLY_TRIGGERED: 
            case DELETE: {
                break;
            }
            default: {
                this.ourLog.trace("Not processing modified message for {}", (Object)theMsg.getOperationType());
                return;
            }
        }
        HookParams params = new HookParams().add(ResourceModifiedMessage.class, (Object)theMsg);
        if (!this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.SUBSCRIPTION_BEFORE_PERSISTED_RESOURCE_CHECKED, params)) {
            return;
        }
        try {
            this.doMatchActiveSubscriptionsAndDeliver(theMsg);
        }
        finally {
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.SUBSCRIPTION_AFTER_PERSISTED_RESOURCE_CHECKED, params);
        }
    }

    private void doMatchActiveSubscriptionsAndDeliver(ResourceModifiedMessage theMsg) {
        IIdType resourceId = theMsg.getPayloadId(this.myFhirContext);
        Collection<ActiveSubscription> subscriptions = this.mySubscriptionRegistry.getAll();
        this.ourLog.trace("Testing {} subscriptions for applicability", (Object)subscriptions.size());
        boolean anySubscriptionsMatchedResource = false;
        for (ActiveSubscription nextActiveSubscription : subscriptions) {
            anySubscriptionsMatchedResource |= this.processSubscription(theMsg, resourceId, nextActiveSubscription);
        }
        if (!anySubscriptionsMatchedResource) {
            HookParams params = new HookParams().add(ResourceModifiedMessage.class, (Object)theMsg);
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.SUBSCRIPTION_RESOURCE_DID_NOT_MATCH_ANY_SUBSCRIPTIONS, params);
        }
    }

    private boolean processSubscription(ResourceModifiedMessage theMsg, IIdType theResourceId, ActiveSubscription theActiveSubscription) {
        InMemoryMatchResult matchResult;
        CanonicalSubscription subscription = theActiveSubscription.getSubscription();
        if (subscription != null && theMsg.getPartitionId() != null && theMsg.getPartitionId().hasPartitionIds() && !subscription.getCrossPartitionEnabled() && !theMsg.getPartitionId().hasPartitionId(subscription.getRequestPartitionId())) {
            return false;
        }
        String nextSubscriptionId = this.getId(theActiveSubscription);
        if (StringUtils.isNotBlank((CharSequence)theMsg.getSubscriptionId()) && !theMsg.getSubscriptionId().equals(nextSubscriptionId)) {
            this.ourLog.debug("Ignoring subscription {} because it is not {}", (Object)nextSubscriptionId, (Object)theMsg.getSubscriptionId());
            return false;
        }
        if (!this.resourceTypeIsAppropriateForSubscription(theActiveSubscription, theResourceId)) {
            return false;
        }
        if (theMsg.getOperationType().equals((Object)BaseResourceMessage.OperationTypeEnum.DELETE) && !theActiveSubscription.getSubscription().getSendDeleteMessages()) {
            this.ourLog.trace("Not processing modified message for {}", (Object)theMsg.getOperationType());
            return false;
        }
        if (theActiveSubscription.getCriteria().getType() == SubscriptionCriteriaParser.TypeEnum.SEARCH_EXPRESSION) {
            matchResult = this.mySubscriptionMatcher.match(theActiveSubscription.getSubscription(), theMsg);
            if (!matchResult.matched()) {
                this.ourLog.trace("Subscription {} was not matched by resource {} {}", new Object[]{theActiveSubscription.getId(), theResourceId.toUnqualifiedVersionless().getValue(), matchResult.isInMemory() ? "in-memory" : "by querying the repository"});
                return false;
            }
            this.ourLog.debug("Subscription {} was matched by resource {} {}", new Object[]{theActiveSubscription.getId(), theResourceId.toUnqualifiedVersionless().getValue(), matchResult.isInMemory() ? "in-memory" : "by querying the repository"});
        } else {
            this.ourLog.trace("Subscription {} was not matched by resource {} - No search expression", (Object)theActiveSubscription.getId(), (Object)theResourceId.toUnqualifiedVersionless().getValue());
            matchResult = InMemoryMatchResult.successfulMatch();
            matchResult.setInMemory(true);
        }
        IBaseResource payload = theMsg.getNewPayload(this.myFhirContext);
        EncodingEnum encoding = null;
        if (subscription != null && subscription.getPayloadString() != null && !subscription.getPayloadString().isEmpty()) {
            encoding = EncodingEnum.forContentType((String)subscription.getPayloadString());
        }
        encoding = (EncodingEnum)ObjectUtils.defaultIfNull(encoding, (Object)EncodingEnum.JSON);
        ResourceDeliveryMessage deliveryMsg = new ResourceDeliveryMessage();
        deliveryMsg.setPartitionId(theMsg.getPartitionId());
        if (payload != null) {
            deliveryMsg.setPayload(this.myFhirContext, payload, encoding);
        } else {
            deliveryMsg.setPayloadId(theMsg.getPayloadId(this.myFhirContext));
        }
        deliveryMsg.setSubscription(subscription);
        deliveryMsg.setOperationType(theMsg.getOperationType());
        deliveryMsg.setTransactionId(theMsg.getTransactionId());
        deliveryMsg.copyAdditionalPropertiesFrom((BaseResourceMessage)theMsg);
        HookParams params = new HookParams().add(CanonicalSubscription.class, (Object)theActiveSubscription.getSubscription()).add(ResourceDeliveryMessage.class, (Object)deliveryMsg).add(InMemoryMatchResult.class, (Object)matchResult);
        if (!this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.SUBSCRIPTION_RESOURCE_MATCHED, params)) {
            this.ourLog.info("Interceptor has decided to abort processing of subscription {}", (Object)nextSubscriptionId);
            return false;
        }
        return this.sendToDeliveryChannel(theActiveSubscription, deliveryMsg);
    }

    private boolean sendToDeliveryChannel(ActiveSubscription nextActiveSubscription, ResourceDeliveryMessage theDeliveryMsg) {
        boolean retVal = false;
        ResourceDeliveryJsonMessage wrappedMsg = new ResourceDeliveryJsonMessage(theDeliveryMsg);
        MessageChannel deliveryChannel = this.mySubscriptionChannelRegistry.getDeliverySenderChannel(nextActiveSubscription.getChannelName());
        if (deliveryChannel != null) {
            retVal = true;
            this.trySendToDeliveryChannel(wrappedMsg, deliveryChannel);
        } else {
            this.ourLog.warn("Do not have delivery channel for subscription {}", (Object)nextActiveSubscription.getId());
        }
        return retVal;
    }

    private void trySendToDeliveryChannel(ResourceDeliveryJsonMessage theWrappedMsg, MessageChannel theDeliveryChannel) {
        try {
            boolean success = theDeliveryChannel.send((Message)theWrappedMsg);
            if (!success) {
                this.ourLog.warn("Failed to send message to Delivery Channel.");
            }
        }
        catch (RuntimeException e) {
            this.ourLog.error("Failed to send message to Delivery Channel", (Throwable)e);
            throw new RuntimeException(Msg.code((int)7) + "Failed to send message to Delivery Channel", e);
        }
    }

    private String getId(ActiveSubscription theActiveSubscription) {
        return theActiveSubscription.getId();
    }

    private boolean resourceTypeIsAppropriateForSubscription(ActiveSubscription theActiveSubscription, IIdType theResourceId) {
        SubscriptionCriteriaParser.SubscriptionCriteria criteria = theActiveSubscription.getCriteria();
        String subscriptionId = this.getId(theActiveSubscription);
        String resourceType = theResourceId.getResourceType();
        this.ourLog.trace("Checking subscription {} for {} with criteria {}", new Object[]{subscriptionId, resourceType, criteria});
        if (criteria == null) {
            this.ourLog.trace("Subscription {} has no criteria - Not matching", (Object)subscriptionId);
            return false;
        }
        switch (criteria.getType()) {
            default: {
                boolean contains = criteria.getApplicableResourceTypes().contains(resourceType);
                this.ourLog.trace("Subscription {} applicable resource type check: {}", (Object)subscriptionId, (Object)contains);
                return contains;
            }
            case STARTYPE_EXPRESSION: 
        }
        boolean match = !resourceType.equals("Subscription");
        this.ourLog.trace("Subscription {} start resource type check: {}", (Object)subscriptionId, (Object)match);
        return match;
    }
}

