/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.subscriber;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.BaseSubscriberForSubscriptionResources;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionCanonicalizer;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionRegistry;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.server.exceptions.ResourceGoneException;
import javax.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;

public class SubscriptionRegisteringSubscriber
extends BaseSubscriberForSubscriptionResources
implements MessageHandler {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionRegisteringSubscriber.class);
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private SubscriptionRegistry mySubscriptionRegistry;
    @Autowired
    private SubscriptionCanonicalizer mySubscriptionCanonicalizer;
    @Autowired
    private DaoRegistry myDaoRegistry;

    public void handleMessage(@Nonnull Message<?> theMessage) throws MessagingException {
        IBaseResource payloadResource;
        if (!(theMessage instanceof ResourceModifiedJsonMessage)) {
            ourLog.warn("Received message of unexpected type on matching channel: {}", theMessage);
            return;
        }
        ResourceModifiedMessage payload = ((ResourceModifiedJsonMessage)theMessage).getPayload();
        if (!this.isSubscription(payload)) {
            return;
        }
        switch (payload.getOperationType()) {
            case MANUALLY_TRIGGERED: 
            case TRANSACTION: {
                return;
            }
        }
        IIdType payloadId = payload.getPayloadId(this.myFhirContext).toUnqualifiedVersionless();
        try {
            IFhirResourceDao subscriptionDao = this.myDaoRegistry.getResourceDao("Subscription");
            RequestDetails systemRequestDetails = this.getPartitionAwareRequestDetails(payload);
            payloadResource = subscriptionDao.read(payloadId, systemRequestDetails);
            if (payloadResource == null) {
                payloadResource = payload.getPayload(this.myFhirContext);
            }
        }
        catch (ResourceGoneException e) {
            this.mySubscriptionRegistry.unregisterSubscriptionIfRegistered(payloadId.getIdPart());
            return;
        }
        String statusString = this.mySubscriptionCanonicalizer.getSubscriptionStatus(payloadResource);
        if ("active".equals(statusString)) {
            this.mySubscriptionRegistry.registerSubscriptionUnlessAlreadyRegistered(payloadResource);
        } else {
            this.mySubscriptionRegistry.unregisterSubscriptionIfRegistered(payloadId.getIdPart());
        }
    }

    private RequestDetails getPartitionAwareRequestDetails(ResourceModifiedMessage payload) {
        RequestPartitionId payloadPartitionId = payload.getPartitionId();
        if (payloadPartitionId == null || payloadPartitionId.isDefaultPartition()) {
            payloadPartitionId = RequestPartitionId.defaultPartition();
        }
        return new SystemRequestDetails().setRequestPartitionId(payloadPartitionId);
    }
}

