/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.registry;

import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.subscription.channel.subscription.ISubscriptionDeliveryChannelNamer;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelRegistry;
import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscriptionCache;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionCanonicalizer;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.ChannelRetryConfiguration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SubscriptionRegistry {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionRegistry.class);
    private final ActiveSubscriptionCache myActiveSubscriptionCache = new ActiveSubscriptionCache();
    @Autowired
    private SubscriptionCanonicalizer mySubscriptionCanonicalizer;
    @Autowired
    private ISubscriptionDeliveryChannelNamer mySubscriptionDeliveryChannelNamer;
    @Autowired
    private SubscriptionChannelRegistry mySubscriptionChannelRegistry;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;

    public synchronized ActiveSubscription get(String theIdPart) {
        return this.myActiveSubscriptionCache.get(theIdPart);
    }

    public synchronized Collection<ActiveSubscription> getAll() {
        return this.myActiveSubscriptionCache.getAll();
    }

    private Optional<CanonicalSubscription> hasSubscription(IIdType theId) {
        Validate.notNull((Object)theId);
        Validate.notBlank((CharSequence)theId.getIdPart());
        Optional<ActiveSubscription> activeSubscription = Optional.ofNullable(this.myActiveSubscriptionCache.get(theId.getIdPart()));
        return activeSubscription.map(ActiveSubscription::getSubscription);
    }

    private ChannelRetryConfiguration getRetryConfigurationFromSubscriptionExtensions(CanonicalSubscription theSubscription) {
        ChannelRetryConfiguration configuration = new ChannelRetryConfiguration();
        List retryCount = theSubscription.getChannelExtensions("http://hapifhir.io/fhir/StructureDefinition/subscription-delivery-retry-count");
        if (retryCount.size() == 1) {
            String val = (String)retryCount.get(0);
            configuration.setRetryCount(Integer.parseInt(val));
        }
        if (configuration.getRetryCount() == null || configuration.getRetryCount() < 0) {
            configuration = null;
        }
        return configuration;
    }

    private void registerSubscription(IIdType theId, CanonicalSubscription theCanonicalSubscription) {
        Validate.notNull((Object)theId);
        String subscriptionId = theId.getIdPart();
        Validate.notBlank((CharSequence)subscriptionId);
        Validate.notNull((Object)theCanonicalSubscription);
        String channelName = this.mySubscriptionDeliveryChannelNamer.nameFromSubscription(theCanonicalSubscription);
        ChannelRetryConfiguration configuration = this.getRetryConfigurationFromSubscriptionExtensions(theCanonicalSubscription);
        ActiveSubscription activeSubscription = new ActiveSubscription(theCanonicalSubscription, channelName);
        activeSubscription.setRetryConfiguration(configuration);
        this.mySubscriptionChannelRegistry.add(activeSubscription);
        this.myActiveSubscriptionCache.put(subscriptionId, activeSubscription);
        ourLog.info("Registered active subscription Subscription/{} - Have {} registered", (Object)subscriptionId, (Object)this.myActiveSubscriptionCache.size());
        HookParams params = new HookParams().add(CanonicalSubscription.class, (Object)theCanonicalSubscription);
        this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.SUBSCRIPTION_AFTER_ACTIVE_SUBSCRIPTION_REGISTERED, params);
    }

    public synchronized void unregisterSubscriptionIfRegistered(String theSubscriptionId) {
        Validate.notNull((Object)theSubscriptionId);
        ActiveSubscription activeSubscription = this.myActiveSubscriptionCache.remove(theSubscriptionId);
        if (activeSubscription != null) {
            this.mySubscriptionChannelRegistry.remove(activeSubscription);
            ourLog.info("Unregistered active subscription {} - Have {} registered", (Object)theSubscriptionId, (Object)this.myActiveSubscriptionCache.size());
            HookParams params = new HookParams();
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.SUBSCRIPTION_AFTER_ACTIVE_SUBSCRIPTION_UNREGISTERED, params);
        }
    }

    @PreDestroy
    public synchronized void unregisterAllSubscriptions() {
        this.unregisterAllSubscriptionsNotInCollection(Collections.emptyList());
        this.unregisterAllSubscriptionsNotInCollection(Collections.emptyList());
    }

    synchronized void unregisterAllSubscriptionsNotInCollection(Collection<String> theAllIds) {
        List<String> idsToDelete = this.myActiveSubscriptionCache.markAllSubscriptionsNotInCollectionForDeletionAndReturnIdsToDelete(theAllIds);
        for (String id : idsToDelete) {
            this.unregisterSubscriptionIfRegistered(id);
        }
    }

    public synchronized boolean registerSubscriptionUnlessAlreadyRegistered(IBaseResource theSubscription) {
        Validate.notNull((Object)theSubscription);
        Optional<CanonicalSubscription> existingSubscription = this.hasSubscription(theSubscription.getIdElement());
        CanonicalSubscription newSubscription = this.mySubscriptionCanonicalizer.canonicalize(theSubscription);
        if (existingSubscription.isPresent()) {
            if (newSubscription.equals((Object)existingSubscription.get())) {
                return false;
            }
            ourLog.info("Updating already-registered active subscription {}", (Object)theSubscription.getIdElement().toUnqualified().getValue());
            if (this.channelTypeSame(existingSubscription.get(), newSubscription)) {
                ourLog.info("Channel type is same.  Updating active subscription and re-using existing channel and handlers.");
                this.updateSubscription(theSubscription);
                return true;
            }
            this.unregisterSubscriptionIfRegistered(theSubscription.getIdElement().getIdPart());
        }
        if (Subscription.SubscriptionStatus.ACTIVE.equals((Object)newSubscription.getStatus())) {
            this.registerSubscription(theSubscription.getIdElement(), newSubscription);
            return true;
        }
        return false;
    }

    private void updateSubscription(IBaseResource theSubscription) {
        IIdType theId = theSubscription.getIdElement();
        Validate.notNull((Object)theId);
        Validate.notBlank((CharSequence)theId.getIdPart());
        ActiveSubscription activeSubscription = this.myActiveSubscriptionCache.get(theId.getIdPart());
        Validate.notNull((Object)activeSubscription);
        CanonicalSubscription canonicalized = this.mySubscriptionCanonicalizer.canonicalize(theSubscription);
        activeSubscription.setSubscription(canonicalized);
        HookParams params = new HookParams().add(CanonicalSubscription.class, (Object)canonicalized);
        this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.SUBSCRIPTION_AFTER_ACTIVE_SUBSCRIPTION_REGISTERED, params);
    }

    private boolean channelTypeSame(CanonicalSubscription theExistingSubscription, CanonicalSubscription theNewSubscription) {
        return theExistingSubscription.getChannelType().equals((Object)theNewSubscription.getChannelType());
    }

    public int size() {
        return this.myActiveSubscriptionCache.size();
    }
}

