/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.submit.interceptor;

import ca.uhn.fhir.interceptor.api.IInterceptorService;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.SubscriptionMatcherInterceptor;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.SubscriptionValidatingInterceptor;
import com.google.common.annotations.VisibleForTesting;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SubscriptionSubmitInterceptorLoader {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionSubmitInterceptorLoader.class);
    @Autowired
    private SubscriptionMatcherInterceptor mySubscriptionMatcherInterceptor;
    @Autowired
    private SubscriptionValidatingInterceptor mySubscriptionValidatingInterceptor;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private IInterceptorService myInterceptorRegistry;
    private boolean mySubscriptionValidatingInterceptorRegistered;
    private boolean mySubscriptionMatcherInterceptorRegistered;

    @PostConstruct
    public void start() {
        Set supportedSubscriptionTypes = this.myDaoConfig.getSupportedSubscriptionTypes();
        if (supportedSubscriptionTypes.isEmpty()) {
            ourLog.info("Subscriptions are disabled on this server.  Subscriptions will not be activated and incoming resources will not be matched against subscriptions.");
        } else if (!this.mySubscriptionMatcherInterceptorRegistered) {
            ourLog.info("Registering subscription matcher interceptor");
            this.myInterceptorRegistry.registerInterceptor((Object)this.mySubscriptionMatcherInterceptor);
            this.mySubscriptionMatcherInterceptorRegistered = true;
        }
        if (!this.mySubscriptionValidatingInterceptorRegistered) {
            this.myInterceptorRegistry.registerInterceptor((Object)this.mySubscriptionValidatingInterceptor);
            this.mySubscriptionValidatingInterceptorRegistered = true;
        }
    }

    @VisibleForTesting
    public void unregisterInterceptorsForUnitTest() {
        this.myInterceptorRegistry.unregisterInterceptor((Object)this.mySubscriptionMatcherInterceptor);
        this.myInterceptorRegistry.unregisterInterceptor((Object)this.mySubscriptionValidatingInterceptor);
        this.mySubscriptionValidatingInterceptorRegistered = false;
        this.mySubscriptionMatcherInterceptorRegistered = false;
    }
}

