/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.submit.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.SubscriptionMatchingStrategy;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.SubscriptionStrategyEvaluator;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionCriteriaParser;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionCanonicalizer;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscriptionChannelType;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.util.SubscriptionUtil;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Autowired;

@Interceptor
public class SubscriptionValidatingInterceptor {
    @Autowired
    private SubscriptionCanonicalizer mySubscriptionCanonicalizer;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private SubscriptionStrategyEvaluator mySubscriptionStrategyEvaluator;
    private FhirContext myFhirContext;
    @Autowired
    private IRequestPartitionHelperSvc myRequestPartitionHelperSvc;

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED)
    public void resourcePreCreate(IBaseResource theResource, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId) {
        this.validateSubmittedSubscription(theResource, theRequestDetails, theRequestPartitionId, Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED);
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED)
    public void resourceUpdated(IBaseResource theOldResource, IBaseResource theResource, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId) {
        this.validateSubmittedSubscription(theResource, theRequestDetails, theRequestPartitionId, Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED);
    }

    @Autowired
    public void setFhirContext(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    @Deprecated
    public void validateSubmittedSubscription(IBaseResource theSubscription) {
        this.validateSubmittedSubscription(theSubscription, null, null, Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED);
    }

    @Deprecated(since="6.3.14")
    public void validateSubmittedSubscription(IBaseResource theSubscription, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId) {
        this.validateSubmittedSubscription(theSubscription, theRequestDetails, theRequestPartitionId, Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED);
    }

    @VisibleForTesting
    void validateSubmittedSubscription(IBaseResource theSubscription, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId, Pointcut thePointcut) {
        CanonicalSubscription subscription;
        if (Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED != thePointcut && Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED != thePointcut) {
            throw new UnprocessableEntityException(Msg.code((int)2267) + "Expected Pointcut to be either STORAGE_PRESTORAGE_RESOURCE_CREATED or STORAGE_PRESTORAGE_RESOURCE_UPDATED but was: " + thePointcut);
        }
        if (!"Subscription".equals(this.myFhirContext.getResourceType(theSubscription))) {
            return;
        }
        try {
            subscription = this.mySubscriptionCanonicalizer.canonicalize(theSubscription);
        }
        catch (InternalErrorException e) {
            throw new UnprocessableEntityException(Msg.code((int)955) + e.getMessage());
        }
        boolean finished = false;
        if (subscription.getStatus() == null) {
            throw new UnprocessableEntityException(Msg.code((int)8) + "Can not process submitted Subscription - Subscription.status must be populated on this server");
        }
        switch (subscription.getStatus()) {
            case REQUESTED: 
            case ACTIVE: {
                break;
            }
            case ERROR: 
            case OFF: 
            case NULL: {
                finished = true;
            }
        }
        this.validatePermissions(theSubscription, subscription, theRequestDetails, theRequestPartitionId, thePointcut);
        this.mySubscriptionCanonicalizer.setMatchingStrategyTag(theSubscription, null);
        if (!finished) {
            this.validateQuery(subscription.getCriteriaString(), "Subscription.criteria");
            if (subscription.getPayloadSearchCriteria() != null) {
                this.validateQuery(subscription.getPayloadSearchCriteria(), "Subscription.extension(url='http://hapifhir.io/fhir/StructureDefinition/subscription-payload-search-criteria')");
            }
            this.validateChannelType(subscription);
            try {
                SubscriptionMatchingStrategy strategy = this.mySubscriptionStrategyEvaluator.determineStrategy(subscription.getCriteriaString());
                this.mySubscriptionCanonicalizer.setMatchingStrategyTag(theSubscription, strategy);
            }
            catch (DataFormatException | InvalidRequestException e) {
                throw new UnprocessableEntityException(Msg.code((int)9) + "Invalid subscription criteria submitted: " + subscription.getCriteriaString() + " " + e.getMessage());
            }
            if (subscription.getChannelType() == null) {
                throw new UnprocessableEntityException(Msg.code((int)10) + "Subscription.channel.type must be populated on this server");
            }
            if (subscription.getChannelType() == CanonicalSubscriptionChannelType.MESSAGE) {
                this.validateMessageSubscriptionEndpoint(subscription.getEndpointUrl());
            }
        }
    }

    protected void validatePermissions(IBaseResource theSubscription, CanonicalSubscription theCanonicalSubscription, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId, Pointcut thePointcut) {
        if (SubscriptionUtil.isCrossPartition((IBaseResource)theSubscription) && !(theRequestDetails instanceof SystemRequestDetails)) {
            RequestPartitionId toCheckPartitionId;
            if (!this.myDaoConfig.isCrossPartitionSubscriptionEnabled()) {
                throw new UnprocessableEntityException(Msg.code((int)2009) + "Cross partition subscription is not enabled on this server");
            }
            if (theRequestPartitionId == null && Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED == thePointcut) {
                return;
            }
            RequestPartitionId requestPartitionId = toCheckPartitionId = theRequestPartitionId != null ? theRequestPartitionId : this.determinePartition(theRequestDetails, theSubscription);
            if (!toCheckPartitionId.isDefaultPartition()) {
                throw new UnprocessableEntityException(Msg.code((int)2010) + "Cross partition subscription must be created on the default partition");
            }
        }
    }

    private RequestPartitionId determinePartition(RequestDetails theRequestDetails, IBaseResource theResource) {
        switch (theRequestDetails.getRestOperationType()) {
            case CREATE: {
                return this.myRequestPartitionHelperSvc.determineCreatePartitionForRequest(theRequestDetails, theResource, "Subscription");
            }
            case UPDATE: {
                return this.myRequestPartitionHelperSvc.determineReadPartitionForRequestForRead(theRequestDetails, "Subscription", theResource.getIdElement());
            }
        }
        return null;
    }

    public void validateQuery(String theQuery, String theFieldName) {
        if (StringUtils.isBlank((CharSequence)theQuery)) {
            throw new UnprocessableEntityException(Msg.code((int)11) + theFieldName + " must be populated");
        }
        SubscriptionCriteriaParser.SubscriptionCriteria parsedCriteria = SubscriptionCriteriaParser.parse(theQuery);
        if (parsedCriteria == null) {
            throw new UnprocessableEntityException(Msg.code((int)12) + theFieldName + " can not be parsed");
        }
        if (parsedCriteria.getType() == SubscriptionCriteriaParser.TypeEnum.STARTYPE_EXPRESSION) {
            return;
        }
        for (String next : parsedCriteria.getApplicableResourceTypes()) {
            if (this.myDaoRegistry.isResourceTypeSupported(next)) continue;
            throw new UnprocessableEntityException(Msg.code((int)13) + theFieldName + " contains invalid/unsupported resource type: " + next);
        }
        if (parsedCriteria.getType() != SubscriptionCriteriaParser.TypeEnum.SEARCH_EXPRESSION) {
            return;
        }
        int sep = theQuery.indexOf(63);
        if (sep <= 1) {
            throw new UnprocessableEntityException(Msg.code((int)14) + theFieldName + " must be in the form \"{Resource Type}?[params]\"");
        }
        String resType = theQuery.substring(0, sep);
        if (resType.contains("/")) {
            throw new UnprocessableEntityException(Msg.code((int)15) + theFieldName + " must be in the form \"{Resource Type}?[params]\"");
        }
    }

    public void validateMessageSubscriptionEndpoint(String theEndpointUrl) {
        if (theEndpointUrl == null) {
            throw new UnprocessableEntityException(Msg.code((int)16) + "No endpoint defined for message subscription");
        }
        try {
            URI uri = new URI(theEndpointUrl);
            if (!"channel".equals(uri.getScheme())) {
                throw new UnprocessableEntityException(Msg.code((int)17) + "Only 'channel' protocol is supported for Subscriptions with channel type 'message'");
            }
            String channelName = uri.getSchemeSpecificPart();
            if (StringUtils.isBlank((CharSequence)channelName)) {
                throw new UnprocessableEntityException(Msg.code((int)18) + "A channel name must appear after channel: in a message Subscription endpoint");
            }
        }
        catch (URISyntaxException e) {
            throw new UnprocessableEntityException(Msg.code((int)19) + "Invalid subscription endpoint uri " + theEndpointUrl, (Throwable)e);
        }
    }

    protected void validateChannelType(CanonicalSubscription theSubscription) {
        if (theSubscription.getChannelType() == null) {
            throw new UnprocessableEntityException(Msg.code((int)20) + "Subscription.channel.type must be populated");
        }
        if (theSubscription.getChannelType() == CanonicalSubscriptionChannelType.RESTHOOK) {
            this.validateChannelPayload(theSubscription);
            this.validateChannelEndpoint(theSubscription);
        }
    }

    protected void validateChannelEndpoint(CanonicalSubscription theResource) {
        if (StringUtils.isBlank((CharSequence)theResource.getEndpointUrl())) {
            throw new UnprocessableEntityException(Msg.code((int)21) + "Rest-hook subscriptions must have Subscription.channel.endpoint defined");
        }
    }

    protected void validateChannelPayload(CanonicalSubscription theResource) {
        if (!StringUtils.isBlank((CharSequence)theResource.getPayloadString()) && EncodingEnum.forContentType((String)theResource.getPayloadString()) == null) {
            throw new UnprocessableEntityException(Msg.code((int)1985) + "Invalid value for Subscription.channel.payload: " + theResource.getPayloadString());
        }
    }

    @VisibleForTesting
    public void setSubscriptionCanonicalizerForUnitTest(SubscriptionCanonicalizer theSubscriptionCanonicalizer) {
        this.mySubscriptionCanonicalizer = theSubscriptionCanonicalizer;
    }

    @VisibleForTesting
    public void setDaoRegistryForUnitTest(DaoRegistry theDaoRegistry) {
        this.myDaoRegistry = theDaoRegistry;
    }

    @VisibleForTesting
    public void setDaoConfigForUnitTest(DaoConfig theDaoConfig) {
        this.myDaoConfig = theDaoConfig;
    }

    @VisibleForTesting
    public void setRequestPartitionHelperSvcForUnitTest(IRequestPartitionHelperSvc theRequestPartitionHelperSvc) {
        this.myRequestPartitionHelperSvc = theRequestPartitionHelperSvc;
    }

    @VisibleForTesting
    public void setSubscriptionStrategyEvaluatorForUnitTest(SubscriptionStrategyEvaluator theSubscriptionStrategyEvaluator) {
        this.mySubscriptionStrategyEvaluator = theSubscriptionStrategyEvaluator;
    }
}

