/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.async;

import ca.uhn.fhir.jpa.model.sched.HapiJob;
import ca.uhn.fhir.jpa.model.sched.IHasScheduledJobs;
import ca.uhn.fhir.jpa.model.sched.ISchedulerService;
import ca.uhn.fhir.jpa.model.sched.ScheduledJobDefinition;
import ca.uhn.fhir.jpa.subscription.async.AsyncResourceModifiedSubmitterSvc;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;

public class AsyncResourceModifiedProcessingSchedulerSvc
implements IHasScheduledJobs {
    public static final long DEFAULT_SUBMISSION_INTERVAL_IN_MS = 5000L;
    public long mySubmissionIntervalInMilliSeconds;

    public AsyncResourceModifiedProcessingSchedulerSvc() {
        this(5000L);
    }

    public AsyncResourceModifiedProcessingSchedulerSvc(long theSubmissionIntervalInMilliSeconds) {
        this.mySubmissionIntervalInMilliSeconds = theSubmissionIntervalInMilliSeconds;
    }

    public void scheduleJobs(ISchedulerService theSchedulerService) {
        ScheduledJobDefinition jobDetail = new ScheduledJobDefinition();
        jobDetail.setId(this.getClass().getName());
        jobDetail.setJobClass(Job.class);
        theSchedulerService.scheduleClusteredJob(this.mySubmissionIntervalInMilliSeconds, jobDetail);
    }

    public static class Job
    implements HapiJob {
        @Autowired
        private AsyncResourceModifiedSubmitterSvc myAsyncResourceModifiedSubmitterSvc;

        public void execute(JobExecutionContext theContext) {
            this.myAsyncResourceModifiedSubmitterSvc.runDeliveryPass();
        }
    }
}

