/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.async;

import ca.uhn.fhir.jpa.model.entity.IPersistedResourceModifiedMessage;
import ca.uhn.fhir.subscription.api.IResourceModifiedConsumerWithRetries;
import ca.uhn.fhir.subscription.api.IResourceModifiedMessagePersistenceSvc;
import com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class AsyncResourceModifiedSubmitterSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(AsyncResourceModifiedSubmitterSvc.class);
    public static final int MAX_LIMIT = 1000;
    private final IResourceModifiedMessagePersistenceSvc myResourceModifiedMessagePersistenceSvc;
    private final IResourceModifiedConsumerWithRetries myResourceModifiedConsumer;

    public AsyncResourceModifiedSubmitterSvc(IResourceModifiedMessagePersistenceSvc theResourceModifiedMessagePersistenceSvc, IResourceModifiedConsumerWithRetries theResourceModifiedConsumer) {
        this.myResourceModifiedMessagePersistenceSvc = theResourceModifiedMessagePersistenceSvc;
        this.myResourceModifiedConsumer = theResourceModifiedConsumer;
    }

    public void runDeliveryPass() {
        boolean hasMoreToFetch = false;
        int limit = AsyncResourceModifiedSubmitterSvc.getLimit();
        block0: do {
            Page persistedResourceModifiedMsgsPage = this.myResourceModifiedMessagePersistenceSvc.findAllOrderedByCreatedTime((Pageable)PageRequest.of((int)0, (int)limit));
            ourLog.debug("Attempting to submit {} resources to consumer channel.", (Object)persistedResourceModifiedMsgsPage.getTotalElements());
            hasMoreToFetch = persistedResourceModifiedMsgsPage.hasNext();
            for (IPersistedResourceModifiedMessage persistedResourceModifiedMessage : persistedResourceModifiedMsgsPage) {
                boolean wasProcessed = this.myResourceModifiedConsumer.submitPersisedResourceModifiedMessage(persistedResourceModifiedMessage);
                if (wasProcessed) continue;
                hasMoreToFetch = false;
                continue block0;
            }
        } while (hasMoreToFetch);
    }

    @VisibleForTesting
    public static int getLimit() {
        return 1000;
    }
}

