/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.subscription;

import ca.uhn.fhir.jpa.subscription.channel.api.ChannelConsumerSettings;
import ca.uhn.fhir.jpa.subscription.channel.api.ChannelProducerSettings;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelProducer;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelReceiver;
import ca.uhn.fhir.jpa.subscription.channel.models.ProducingChannelParameters;
import ca.uhn.fhir.jpa.subscription.channel.models.ReceivingChannelParameters;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelCache;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelFactory;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelWithHandlers;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionDeliveryHandlerFactory;
import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionRegistry;
import ca.uhn.fhir.jpa.subscription.model.ChannelRetryConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;

public class SubscriptionChannelRegistry {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionRegistry.class);
    private final SubscriptionChannelCache myDeliveryReceiverChannels = new SubscriptionChannelCache();
    private final Multimap<String, String> myActiveSubscriptionByChannelName = MultimapBuilder.hashKeys().arrayListValues().build();
    private final Map<String, IChannelProducer> myChannelNameToSender = new ConcurrentHashMap<String, IChannelProducer>();
    @Autowired
    private SubscriptionDeliveryHandlerFactory mySubscriptionDeliveryHandlerFactory;
    @Autowired
    private SubscriptionChannelFactory mySubscriptionDeliveryChannelFactory;

    public synchronized void add(ActiveSubscription theActiveSubscription) {
        String channelName = theActiveSubscription.getChannelName();
        ourLog.info("Adding subscription {} to channel {}", (Object)theActiveSubscription.getId(), (Object)channelName);
        this.myActiveSubscriptionByChannelName.put((Object)channelName, (Object)theActiveSubscription.getId());
        if (this.myDeliveryReceiverChannels.containsKey(channelName)) {
            ourLog.info("Channel {} already exists.  Not creating.", (Object)channelName);
            return;
        }
        ChannelRetryConfiguration retryConfigParameters = theActiveSubscription.getRetryConfigurationParameters();
        ReceivingChannelParameters receivingParameters = new ReceivingChannelParameters(channelName);
        receivingParameters.setRetryConfiguration(retryConfigParameters);
        IChannelReceiver channelReceiver = this.newReceivingChannel(receivingParameters);
        Optional<MessageHandler> deliveryHandler = this.mySubscriptionDeliveryHandlerFactory.createDeliveryHandler(theActiveSubscription.getChannelType());
        SubscriptionChannelWithHandlers subscriptionChannelWithHandlers = new SubscriptionChannelWithHandlers(channelName, (SubscribableChannel)channelReceiver);
        deliveryHandler.ifPresent(subscriptionChannelWithHandlers::addHandler);
        this.myDeliveryReceiverChannels.put(channelName, subscriptionChannelWithHandlers);
        ProducingChannelParameters producingChannelParameters = new ProducingChannelParameters(channelName);
        producingChannelParameters.setRetryConfiguration(retryConfigParameters);
        IChannelProducer sendingChannel = this.newSendingChannel(producingChannelParameters);
        this.myChannelNameToSender.put(channelName, sendingChannel);
    }

    protected IChannelReceiver newReceivingChannel(ReceivingChannelParameters theParameters) {
        ChannelConsumerSettings settings = new ChannelConsumerSettings();
        settings.setRetryConfiguration(theParameters.getRetryConfiguration());
        return this.mySubscriptionDeliveryChannelFactory.newDeliveryReceivingChannel(theParameters.getChannelName(), settings);
    }

    protected IChannelProducer newSendingChannel(ProducingChannelParameters theParameters) {
        ChannelProducerSettings settings = new ChannelProducerSettings();
        settings.setRetryConfiguration(theParameters.getRetryConfiguration());
        return this.mySubscriptionDeliveryChannelFactory.newDeliverySendingChannel(theParameters.getChannelName(), settings);
    }

    public synchronized void remove(ActiveSubscription theActiveSubscription) {
        String channelName = theActiveSubscription.getChannelName();
        ourLog.info("Removing subscription {} from channel {}", (Object)theActiveSubscription.getId(), (Object)channelName);
        boolean removed = this.myActiveSubscriptionByChannelName.remove((Object)channelName, (Object)theActiveSubscription.getId());
        if (!removed) {
            ourLog.warn("Failed to remove subscription {} from channel {}", (Object)theActiveSubscription.getId(), (Object)channelName);
        }
        if (!this.myActiveSubscriptionByChannelName.containsKey((Object)channelName)) {
            SubscriptionChannelWithHandlers channel = this.myDeliveryReceiverChannels.get(channelName);
            if (channel != null) {
                channel.close();
            }
            this.myDeliveryReceiverChannels.closeAndRemove(channelName);
            this.myChannelNameToSender.remove(channelName);
        }
    }

    public synchronized SubscriptionChannelWithHandlers getDeliveryReceiverChannel(String theChannelName) {
        return this.myDeliveryReceiverChannels.get(theChannelName);
    }

    public synchronized MessageChannel getDeliverySenderChannel(String theChannelName) {
        return (MessageChannel)this.myChannelNameToSender.get(theChannelName);
    }

    public synchronized int size() {
        return this.myDeliveryReceiverChannels.size();
    }

    @VisibleForTesting
    public void logForUnitTest() {
        this.myDeliveryReceiverChannels.logForUnitTest();
    }
}

