/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.deliver.websocket;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelRegistry;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelWithHandlers;
import ca.uhn.fhir.jpa.subscription.match.deliver.websocket.WebsocketConnectionValidator;
import ca.uhn.fhir.jpa.subscription.match.deliver.websocket.WebsocketValidationResponse;
import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.IdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class SubscriptionWebsocketHandler
extends TextWebSocketHandler
implements WebSocketHandler {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionWebsocketHandler.class);
    @Autowired
    protected WebsocketConnectionValidator myWebsocketConnectionValidator;
    @Autowired
    SubscriptionChannelRegistry mySubscriptionChannelRegistry;
    private IState myState = new InitialState();

    public void afterConnectionClosed(WebSocketSession theSession, CloseStatus theStatus) throws Exception {
        super.afterConnectionClosed(theSession, theStatus);
        ourLog.info("Closing WebSocket connection from {}", (Object)theSession.getRemoteAddress());
    }

    public void afterConnectionEstablished(WebSocketSession theSession) throws Exception {
        super.afterConnectionEstablished(theSession);
        ourLog.info("Incoming WebSocket connection from {}", (Object)theSession.getRemoteAddress());
    }

    protected void handleFailure(Exception theE) {
        ourLog.error("Failure during communication", (Throwable)theE);
    }

    protected void handleTextMessage(WebSocketSession theSession, TextMessage theMessage) throws Exception {
        ourLog.info("Textmessage: " + (String)theMessage.getPayload());
        this.myState.handleTextMessage(theSession, theMessage);
    }

    public void handleTransportError(WebSocketSession theSession, Throwable theException) throws Exception {
        super.handleTransportError(theSession, theException);
        ourLog.error("Transport error", theException);
    }

    @PostConstruct
    public synchronized void postConstruct() {
        ourLog.info("Websocket connection has been created");
    }

    @PreDestroy
    public synchronized void preDescroy() {
        ourLog.info("Websocket connection is closing");
        IState state = this.myState;
        if (state != null) {
            state.closing();
        }
    }

    private class InitialState
    implements IState {
        private InitialState() {
        }

        private IIdType bindSimple(WebSocketSession theSession, String theBindString) {
            IdType id = new IdType(theBindString);
            WebsocketValidationResponse response = SubscriptionWebsocketHandler.this.myWebsocketConnectionValidator.validate(id);
            if (!response.isValid()) {
                try {
                    ourLog.warn(response.getMessage());
                    theSession.close(new CloseStatus(CloseStatus.PROTOCOL_ERROR.getCode(), response.getMessage()));
                }
                catch (IOException e) {
                    SubscriptionWebsocketHandler.this.handleFailure(e);
                }
                return null;
            }
            SubscriptionWebsocketHandler.this.myState = new BoundStaticSubscriptionState(theSession, response.getActiveSubscription());
            return id;
        }

        @Override
        public void closing() {
        }

        @Override
        public void handleTextMessage(WebSocketSession theSession, TextMessage theMessage) {
            String message = (String)theMessage.getPayload();
            if (message.startsWith("bind ")) {
                String remaining = message.substring("bind ".length());
                IIdType subscriptionId = this.bindSimple(theSession, remaining);
                if (subscriptionId == null) {
                    return;
                }
                try {
                    theSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)("bound " + subscriptionId.getIdPart())));
                }
                catch (IOException e) {
                    SubscriptionWebsocketHandler.this.handleFailure(e);
                }
            }
        }
    }

    private static interface IState {
        public void closing();

        public void handleTextMessage(WebSocketSession var1, TextMessage var2);
    }

    private class BoundStaticSubscriptionState
    implements IState,
    MessageHandler {
        private final WebSocketSession mySession;
        private final ActiveSubscription myActiveSubscription;

        public BoundStaticSubscriptionState(WebSocketSession theSession, ActiveSubscription theActiveSubscription) {
            this.mySession = theSession;
            this.myActiveSubscription = theActiveSubscription;
            SubscriptionChannelWithHandlers subscriptionChannelWithHandlers = SubscriptionWebsocketHandler.this.mySubscriptionChannelRegistry.getDeliveryReceiverChannel(theActiveSubscription.getChannelName());
            subscriptionChannelWithHandlers.addHandler(this);
        }

        @Override
        public void closing() {
            SubscriptionChannelWithHandlers subscriptionChannelWithHandlers = SubscriptionWebsocketHandler.this.mySubscriptionChannelRegistry.getDeliveryReceiverChannel(this.myActiveSubscription.getChannelName());
            subscriptionChannelWithHandlers.removeHandler(this);
        }

        private void deliver(String payload) {
            try {
                ourLog.info("Sending WebSocket message: {}", (Object)payload);
                this.mySession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)payload));
            }
            catch (IOException e) {
                SubscriptionWebsocketHandler.this.handleFailure(e);
            }
        }

        public void handleMessage(Message<?> theMessage) {
            if (!(theMessage.getPayload() instanceof ResourceDeliveryMessage)) {
                return;
            }
            try {
                ResourceDeliveryMessage msg = (ResourceDeliveryMessage)theMessage.getPayload();
                this.handleSubscriptionPayload(msg);
            }
            catch (Exception e) {
                this.handleException(theMessage, e);
            }
        }

        private void handleSubscriptionPayload(ResourceDeliveryMessage msg) {
            if (!this.myActiveSubscription.getSubscription().equals((Object)msg.getSubscription())) {
                return;
            }
            String defaultPayload = "ping " + this.myActiveSubscription.getId();
            Object payload = defaultPayload;
            if (msg.getSubscription().isTopicSubscription()) {
                payload = this.getPayloadByContent(msg).orElse(defaultPayload);
            }
            this.deliver((String)payload);
        }

        private void handleException(Message<?> theMessage, Exception e) {
            ourLog.error("Failure handling subscription payload", (Throwable)e);
            throw new MessagingException(theMessage, Msg.code((int)6) + "Failure handling subscription payload", (Throwable)e);
        }

        private Optional<String> getPayloadByContent(ResourceDeliveryMessage msg) {
            if (msg.getSubscription().getContent() == null) {
                return Optional.empty();
            }
            switch (msg.getSubscription().getContent()) {
                case IDONLY: {
                    return Optional.of(msg.getPayloadId());
                }
                case FULLRESOURCE: {
                    return Optional.of(msg.getPayloadString());
                }
            }
            return Optional.empty();
        }

        @Override
        public void handleTextMessage(WebSocketSession theSession, TextMessage theMessage) {
            try {
                theSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)("Unexpected client message: " + (String)theMessage.getPayload())));
            }
            catch (IOException e) {
                SubscriptionWebsocketHandler.this.handleFailure(e);
            }
        }
    }
}

