/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.matching;

import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryResourceMatcher;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.SubscriptionMatchingStrategy;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionCriteriaParser;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import org.springframework.beans.factory.annotation.Autowired;

public class SubscriptionStrategyEvaluator {
    @Autowired
    private InMemoryResourceMatcher myInMemoryResourceMatcher;

    public SubscriptionMatchingStrategy determineStrategy(CanonicalSubscription theSubscription) {
        if (theSubscription.isTopicSubscription()) {
            return SubscriptionMatchingStrategy.TOPIC;
        }
        String criteriaString = theSubscription.getCriteriaString();
        return this.determineStrategy(criteriaString);
    }

    public SubscriptionMatchingStrategy determineStrategy(String criteriaString) {
        SubscriptionCriteriaParser.SubscriptionCriteria criteria = SubscriptionCriteriaParser.parse(criteriaString);
        if (criteria == null) {
            return SubscriptionMatchingStrategy.DATABASE;
        }
        if (criteria.getCriteria() == null) {
            return SubscriptionMatchingStrategy.IN_MEMORY;
        }
        InMemoryMatchResult result = this.myInMemoryResourceMatcher.canBeEvaluatedInMemory(criteriaString);
        if (result.supported()) {
            return SubscriptionMatchingStrategy.IN_MEMORY;
        }
        return SubscriptionMatchingStrategy.DATABASE;
    }
}

