/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.subscriber;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.model.config.SubscriptionSettings;
import ca.uhn.fhir.jpa.subscription.channel.api.ChannelConsumerSettings;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelReceiver;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelFactory;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionActivatingSubscriber;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionMatchingSubscriber;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionRegisteringSubscriber;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicMatchingSubscriber;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicRegisteringSubscriber;
import jakarta.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.messaging.MessageHandler;

public class MatchingQueueSubscriberLoader {
    protected IChannelReceiver myMatchingChannel;
    private static final Logger ourLog = LoggerFactory.getLogger(MatchingQueueSubscriberLoader.class);
    @Autowired
    FhirContext myFhirContext;
    @Autowired
    private SubscriptionMatchingSubscriber mySubscriptionMatchingSubscriber;
    @Autowired(required=false)
    private SubscriptionTopicMatchingSubscriber mySubscriptionTopicMatchingSubscriber;
    @Autowired
    private SubscriptionChannelFactory mySubscriptionChannelFactory;
    @Autowired
    private SubscriptionRegisteringSubscriber mySubscriptionRegisteringSubscriber;
    @Autowired(required=false)
    private SubscriptionTopicRegisteringSubscriber mySubscriptionTopicRegisteringSubscriber;
    @Autowired
    private SubscriptionActivatingSubscriber mySubscriptionActivatingSubscriber;
    @Autowired
    private SubscriptionSettings mySubscriptionSettings;

    @EventListener(value={ContextRefreshedEvent.class})
    @Order(value=300)
    public void subscribeToMatchingChannel() {
        if (this.myMatchingChannel == null) {
            this.myMatchingChannel = this.mySubscriptionChannelFactory.newMatchingReceivingChannel("subscription-matching", this.getChannelConsumerSettings());
        }
        if (this.myMatchingChannel != null) {
            this.myMatchingChannel.subscribe((MessageHandler)this.mySubscriptionMatchingSubscriber);
            this.myMatchingChannel.subscribe((MessageHandler)this.mySubscriptionActivatingSubscriber);
            this.myMatchingChannel.subscribe((MessageHandler)this.mySubscriptionRegisteringSubscriber);
            ourLog.info("Subscription Matching Subscriber subscribed to Matching Channel {} with name {}", (Object)this.myMatchingChannel.getClass().getName(), (Object)"subscription-matching");
            if (this.mySubscriptionTopicMatchingSubscriber != null) {
                ourLog.info("Starting SubscriptionTopic Matching Subscriber");
                this.myMatchingChannel.subscribe((MessageHandler)this.mySubscriptionTopicMatchingSubscriber);
            }
            if (this.mySubscriptionTopicRegisteringSubscriber != null) {
                this.myMatchingChannel.subscribe((MessageHandler)this.mySubscriptionTopicRegisteringSubscriber);
            }
        }
    }

    private ChannelConsumerSettings getChannelConsumerSettings() {
        ChannelConsumerSettings channelConsumerSettings = new ChannelConsumerSettings();
        channelConsumerSettings.setQualifyChannelName(this.mySubscriptionSettings.isQualifySubscriptionMatchingChannelName());
        return channelConsumerSettings;
    }

    @PreDestroy
    public void stop() throws Exception {
        if (this.myMatchingChannel != null) {
            ourLog.info("Destroying matching Channel {} with name {}", (Object)this.myMatchingChannel.getClass().getName(), (Object)"subscription-matching");
            this.myMatchingChannel.destroy();
            this.myMatchingChannel.unsubscribe((MessageHandler)this.mySubscriptionMatchingSubscriber);
            this.myMatchingChannel.unsubscribe((MessageHandler)this.mySubscriptionActivatingSubscriber);
            this.myMatchingChannel.unsubscribe((MessageHandler)this.mySubscriptionRegisteringSubscriber);
        }
    }
}

