/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.subscriber;

import ca.uhn.fhir.jpa.searchparam.extractor.StringTrimmingTrimmerMatcher;
import com.google.common.collect.Sets;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.text.StringTokenizer;
import org.apache.commons.text.matcher.StringMatcher;

public final class SubscriptionCriteriaParser
extends Enum<SubscriptionCriteriaParser> {
    private static final /* synthetic */ SubscriptionCriteriaParser[] $VALUES;

    public static SubscriptionCriteriaParser[] values() {
        return (SubscriptionCriteriaParser[])$VALUES.clone();
    }

    public static SubscriptionCriteriaParser valueOf(String name) {
        return Enum.valueOf(SubscriptionCriteriaParser.class, name);
    }

    @Nullable
    public static SubscriptionCriteria parse(String theCriteria) {
        String criteria = StringUtils.trim((String)theCriteria);
        if (StringUtils.isBlank((CharSequence)criteria)) {
            return null;
        }
        if (criteria.startsWith("[") && criteria.endsWith("]")) {
            String multitypeExpression = criteria.substring(1, criteria.length() - 1);
            StringTokenizer tok = new StringTokenizer(multitypeExpression, ",");
            tok.setTrimmerMatcher((StringMatcher)new StringTrimmingTrimmerMatcher());
            List types = tok.getTokenList();
            if (types.isEmpty()) {
                return null;
            }
            if (types.contains("*")) {
                return new SubscriptionCriteria(TypeEnum.STARTYPE_EXPRESSION, null, null);
            }
            HashSet typesSet = Sets.newHashSet((Iterable)types);
            return new SubscriptionCriteria(TypeEnum.MULTITYPE_EXPRESSION, null, typesSet);
        }
        if (Character.isLetter(criteria.charAt(0))) {
            String criteriaType = criteria;
            int questionMarkIdx = criteriaType.indexOf(63);
            if (questionMarkIdx > 0) {
                criteriaType = criteriaType.substring(0, questionMarkIdx);
            }
            Set<String> types = Collections.singleton(criteriaType);
            return new SubscriptionCriteria(TypeEnum.SEARCH_EXPRESSION, criteria, types);
        }
        return null;
    }

    private static /* synthetic */ SubscriptionCriteriaParser[] $values() {
        return new SubscriptionCriteriaParser[0];
    }

    static {
        $VALUES = SubscriptionCriteriaParser.$values();
    }

    public static class SubscriptionCriteria {
        private final TypeEnum myType;
        private final String myCriteria;
        private final Set<String> myApplicableResourceTypes;

        private SubscriptionCriteria(TypeEnum theType, String theCriteria, Set<String> theApplicableResourceTypes) {
            this.myType = theType;
            this.myCriteria = theCriteria;
            this.myApplicableResourceTypes = theApplicableResourceTypes;
        }

        public String toString() {
            ToStringBuilder retVal = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
            retVal.append("type", (Object)this.myType);
            if (StringUtils.isNotBlank((CharSequence)this.myCriteria)) {
                retVal.append("criteria", (Object)this.myCriteria);
            }
            if (this.myApplicableResourceTypes != null) {
                retVal.append("applicableResourceTypes", this.myApplicableResourceTypes);
            }
            return retVal.toString();
        }

        public TypeEnum getType() {
            return this.myType;
        }

        public String getCriteria() {
            return this.myCriteria;
        }

        public Set<String> getApplicableResourceTypes() {
            return this.myApplicableResourceTypes;
        }
    }

    public static enum TypeEnum {
        SEARCH_EXPRESSION,
        MULTITYPE_EXPRESSION,
        STARTYPE_EXPRESSION;

    }
}

