/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.matcher.subscriber;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.ISubscriptionMatcher;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionCriteriaParser;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionMatchDeliverer;
import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionRegistry;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.rest.server.messaging.BaseResourceMessage;
import ca.uhn.fhir.subscription.api.IResourceModifiedMessagePersistenceSvc;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;

public class SubscriptionMatchingSubscriber
implements MessageHandler {
    private final Logger ourLog = LoggerFactory.getLogger(SubscriptionMatchingSubscriber.class);
    public static final String SUBSCRIPTION_MATCHING_CHANNEL_NAME = "subscription-matching";
    @Autowired
    private ISubscriptionMatcher mySubscriptionMatcher;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private SubscriptionRegistry mySubscriptionRegistry;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private SubscriptionMatchDeliverer mySubscriptionMatchDeliverer;
    @Autowired
    private IResourceModifiedMessagePersistenceSvc myResourceModifiedMessagePersistenceSvc;

    public void handleMessage(@Nonnull Message<?> theMessage) throws MessagingException {
        this.ourLog.trace("Handling resource modified message: {}", theMessage);
        if (!(theMessage instanceof ResourceModifiedJsonMessage)) {
            this.ourLog.warn("Unexpected message payload type: {}", theMessage);
            return;
        }
        ResourceModifiedMessage msg = ((ResourceModifiedJsonMessage)theMessage).getPayload();
        this.matchActiveSubscriptionsAndDeliver(msg);
    }

    public void matchActiveSubscriptionsAndDeliver(ResourceModifiedMessage theMsg) {
        HookParams params;
        switch (theMsg.getOperationType()) {
            case CREATE: 
            case UPDATE: 
            case MANUALLY_TRIGGERED: 
            case DELETE: {
                break;
            }
            default: {
                this.ourLog.trace("Not processing modified message for {}", (Object)theMsg.getOperationType());
                return;
            }
        }
        if (theMsg.getPayload(this.myFhirContext) == null) {
            Optional inflatedMsg = this.myResourceModifiedMessagePersistenceSvc.inflatePersistedResourceModifiedMessageOrNull(theMsg);
            if (inflatedMsg.isEmpty()) {
                return;
            }
            theMsg = (ResourceModifiedMessage)inflatedMsg.get();
        }
        if (!this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.SUBSCRIPTION_BEFORE_PERSISTED_RESOURCE_CHECKED, params = new HookParams().add(ResourceModifiedMessage.class, (Object)theMsg))) {
            return;
        }
        try {
            this.doMatchActiveSubscriptionsAndDeliver(theMsg);
        }
        finally {
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.SUBSCRIPTION_AFTER_PERSISTED_RESOURCE_CHECKED, params);
        }
    }

    private void doMatchActiveSubscriptionsAndDeliver(ResourceModifiedMessage theMsg) {
        IIdType resourceId = theMsg.getPayloadId(this.myFhirContext);
        List<ActiveSubscription> subscriptions = this.mySubscriptionRegistry.getAllNonTopicSubscriptions();
        this.ourLog.trace("Testing {} subscriptions for applicability", (Object)subscriptions.size());
        boolean anySubscriptionsMatchedResource = false;
        for (ActiveSubscription nextActiveSubscription : subscriptions) {
            anySubscriptionsMatchedResource |= this.processSubscription(theMsg, resourceId, nextActiveSubscription);
        }
        if (!anySubscriptionsMatchedResource) {
            HookParams params = new HookParams().add(ResourceModifiedMessage.class, (Object)theMsg);
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.SUBSCRIPTION_RESOURCE_DID_NOT_MATCH_ANY_SUBSCRIPTIONS, params);
        }
    }

    private boolean processSubscription(ResourceModifiedMessage theMsg, IIdType theResourceId, ActiveSubscription theActiveSubscription) {
        InMemoryMatchResult matchResult;
        CanonicalSubscription subscription = theActiveSubscription.getSubscription();
        if (subscription != null && theMsg.getPartitionId() != null && theMsg.getPartitionId().hasPartitionIds() && !subscription.isCrossPartitionEnabled() && !theMsg.getPartitionId().hasPartitionId(subscription.getRequestPartitionId())) {
            return false;
        }
        String nextSubscriptionId = theActiveSubscription.getId();
        if (StringUtils.isNotBlank((CharSequence)theMsg.getSubscriptionId()) && !theMsg.getSubscriptionId().equals(nextSubscriptionId)) {
            this.ourLog.debug("Ignoring subscription {} because it is not {}", (Object)nextSubscriptionId, (Object)theMsg.getSubscriptionId());
            return false;
        }
        if (!this.resourceTypeIsAppropriateForSubscription(theActiveSubscription, theResourceId)) {
            return false;
        }
        if (theMsg.getOperationType().equals((Object)BaseResourceMessage.OperationTypeEnum.DELETE) && !theActiveSubscription.getSubscription().getSendDeleteMessages()) {
            this.ourLog.trace("Not processing modified message for {}", (Object)theMsg.getOperationType());
            return false;
        }
        if (theActiveSubscription.getCriteria().getType() == SubscriptionCriteriaParser.TypeEnum.SEARCH_EXPRESSION) {
            matchResult = this.mySubscriptionMatcher.match(theActiveSubscription.getSubscription(), theMsg);
            if (!matchResult.matched()) {
                this.ourLog.trace("Subscription {} was not matched by resource {} {}", new Object[]{theActiveSubscription.getId(), theResourceId.toUnqualifiedVersionless().getValue(), matchResult.isInMemory() ? "in-memory" : "by querying the repository"});
                return false;
            }
            this.ourLog.debug("Subscription {} was matched by resource {} {}", new Object[]{theActiveSubscription.getId(), theResourceId.toUnqualifiedVersionless().getValue(), matchResult.isInMemory() ? "in-memory" : "by querying the repository"});
        } else {
            this.ourLog.trace("Subscription {} was not matched by resource {} - No search expression", (Object)theActiveSubscription.getId(), (Object)theResourceId.toUnqualifiedVersionless().getValue());
            matchResult = InMemoryMatchResult.successfulMatch();
            matchResult.setInMemory(true);
        }
        IBaseResource payload = theMsg.getNewPayload(this.myFhirContext);
        return this.mySubscriptionMatchDeliverer.deliverPayload(payload, theMsg, theActiveSubscription, matchResult);
    }

    private boolean resourceTypeIsAppropriateForSubscription(ActiveSubscription theActiveSubscription, IIdType theResourceId) {
        SubscriptionCriteriaParser.SubscriptionCriteria criteria = theActiveSubscription.getCriteria();
        String subscriptionId = theActiveSubscription.getId();
        String resourceType = theResourceId.getResourceType();
        this.ourLog.trace("Checking subscription {} for {} with criteria {}", new Object[]{subscriptionId, resourceType, criteria});
        if (criteria == null) {
            this.ourLog.trace("Subscription {} has no criteria - Not matching", (Object)subscriptionId);
            return false;
        }
        switch (criteria.getType()) {
            default: {
                boolean contains = criteria.getApplicableResourceTypes().contains(resourceType);
                this.ourLog.trace("Subscription {} applicable resource type check: {}", (Object)subscriptionId, (Object)contains);
                return contains;
            }
            case STARTYPE_EXPRESSION: 
        }
        boolean match = !resourceType.equals("Subscription");
        this.ourLog.trace("Subscription {} start resource type check: {}", (Object)subscriptionId, (Object)match);
        return match;
    }
}

