/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.registry;

import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionCriteriaParser;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscriptionChannelType;
import ca.uhn.fhir.jpa.subscription.model.ChannelRetryConfiguration;
import java.util.concurrent.atomic.AtomicLong;

public class ActiveSubscription {
    private SubscriptionCriteriaParser.SubscriptionCriteria myCriteria;
    private final String myChannelName;
    private final String myId;
    private CanonicalSubscription mySubscription;
    private boolean flagForDeletion;
    private ChannelRetryConfiguration myRetryConfigurationParameters;
    private final AtomicLong myDeliveriesCount = new AtomicLong();

    public ActiveSubscription(CanonicalSubscription theSubscription, String theChannelName) {
        this.myChannelName = theChannelName;
        this.myId = theSubscription.getIdPart();
        this.setSubscription(theSubscription);
    }

    public SubscriptionCriteriaParser.SubscriptionCriteria getCriteria() {
        return this.myCriteria;
    }

    public CanonicalSubscription getSubscription() {
        return this.mySubscription;
    }

    public final void setSubscription(CanonicalSubscription theSubscription) {
        this.mySubscription = theSubscription;
        this.myCriteria = SubscriptionCriteriaParser.parse(theSubscription.getCriteriaString());
    }

    public String getChannelName() {
        return this.myChannelName;
    }

    public boolean isFlagForDeletion() {
        return this.flagForDeletion;
    }

    public void setFlagForDeletion(boolean theFlagForDeletion) {
        this.flagForDeletion = theFlagForDeletion;
    }

    public String getId() {
        return this.myId;
    }

    public CanonicalSubscriptionChannelType getChannelType() {
        return this.mySubscription.getChannelType();
    }

    public void setRetryConfiguration(ChannelRetryConfiguration theParams) {
        this.myRetryConfigurationParameters = theParams;
    }

    public ChannelRetryConfiguration getRetryConfigurationParameters() {
        return this.myRetryConfigurationParameters;
    }

    public long getDeliveriesCount() {
        return this.myDeliveriesCount.get();
    }

    public long incrementDeliveriesCount() {
        return this.myDeliveriesCount.incrementAndGet();
    }
}

