/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.registry;

import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ActiveSubscriptionCache {
    private static final Logger ourLog = LoggerFactory.getLogger(ActiveSubscriptionCache.class);
    private final Map<String, ActiveSubscription> myCache = new ConcurrentHashMap<String, ActiveSubscription>();

    ActiveSubscriptionCache() {
    }

    public ActiveSubscription get(String theIdPart) {
        return this.myCache.get(theIdPart);
    }

    public Collection<ActiveSubscription> getAll() {
        return Collections.unmodifiableCollection(this.myCache.values());
    }

    public int size() {
        return this.myCache.size();
    }

    public void put(String theSubscriptionId, ActiveSubscription theActiveSubscription) {
        this.myCache.put(theSubscriptionId, theActiveSubscription);
    }

    public synchronized ActiveSubscription remove(String theSubscriptionId) {
        Validate.notBlank((CharSequence)theSubscriptionId);
        ActiveSubscription activeSubscription = this.myCache.get(theSubscriptionId);
        if (activeSubscription == null) {
            return null;
        }
        this.myCache.remove(theSubscriptionId);
        return activeSubscription;
    }

    List<String> markAllSubscriptionsNotInCollectionForDeletionAndReturnIdsToDelete(Collection<String> theAllIds) {
        ArrayList<String> retval = new ArrayList<String>();
        for (String next : new ArrayList<String>(this.myCache.keySet())) {
            ActiveSubscription activeSubscription = this.myCache.get(next);
            if (theAllIds.contains(next)) {
                activeSubscription.setFlagForDeletion(false);
                continue;
            }
            if (activeSubscription.isFlagForDeletion()) {
                ourLog.info("Unregistering Subscription/{}", (Object)next);
                retval.add(next);
                continue;
            }
            activeSubscription.setFlagForDeletion(true);
        }
        return retval;
    }

    public List<ActiveSubscription> getTopicSubscriptionsForTopic(String theTopic) {
        assert (!StringUtils.isBlank((CharSequence)theTopic));
        return this.getAll().stream().filter(as -> as.getSubscription().isTopicSubscription()).filter(as -> theTopic.equals(as.getSubscription().getTopic())).collect(Collectors.toList());
    }

    public List<ActiveSubscription> getAllNonTopicSubscriptions() {
        return this.getAll().stream().filter(as -> !as.getSubscription().isTopicSubscription()).collect(Collectors.toList());
    }
}

