/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.submit.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.SubscriptionSettings;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.messaging.BaseResourceMessage;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.subscription.api.IResourceModifiedMessagePersistenceSvc;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Interceptor
public class SubscriptionMatcherInterceptor {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionMatcherInterceptor.class);
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private SubscriptionSettings mySubscriptionSettings;
    @Autowired
    private IRequestPartitionHelperSvc myRequestPartitionHelperSvc;
    @Autowired
    private IResourceModifiedMessagePersistenceSvc myResourceModifiedMessagePersistenceSvc;

    @Hook(value=Pointcut.STORAGE_PRECOMMIT_RESOURCE_CREATED)
    public void resourceCreated(IBaseResource theResource, RequestDetails theRequest) {
        this.processResourceModifiedEvent(theResource, BaseResourceMessage.OperationTypeEnum.CREATE, theRequest);
    }

    @Hook(value=Pointcut.STORAGE_PRECOMMIT_RESOURCE_DELETED)
    public void resourceDeleted(IBaseResource theResource, RequestDetails theRequest) {
        this.processResourceModifiedEvent(theResource, BaseResourceMessage.OperationTypeEnum.DELETE, theRequest);
    }

    @Hook(value=Pointcut.STORAGE_PRECOMMIT_RESOURCE_UPDATED)
    public void resourceUpdated(IBaseResource theOldResource, IBaseResource theNewResource, RequestDetails theRequest) {
        boolean dontTriggerSubscriptionWhenVersionsAreTheSame = !this.mySubscriptionSettings.isTriggerSubscriptionsForNonVersioningChanges();
        boolean resourceVersionsAreTheSame = this.isSameResourceVersion(theOldResource, theNewResource);
        if (dontTriggerSubscriptionWhenVersionsAreTheSame && resourceVersionsAreTheSame) {
            return;
        }
        this.processResourceModifiedEvent(theNewResource, BaseResourceMessage.OperationTypeEnum.UPDATE, theRequest);
    }

    protected void processResourceModifiedEvent(IBaseResource theNewResource, BaseResourceMessage.OperationTypeEnum theOperationType, RequestDetails theRequest) {
        ResourceModifiedMessage msg = this.createResourceModifiedMessage(theNewResource, theOperationType, theRequest);
        HookParams params = new HookParams().add(ResourceModifiedMessage.class, (Object)msg);
        boolean outcome = CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.SUBSCRIPTION_RESOURCE_MODIFIED, (HookParams)params);
        if (!outcome) {
            return;
        }
        this.processResourceModifiedMessage(msg);
    }

    protected void processResourceModifiedMessage(ResourceModifiedMessage theResourceModifiedMessage) {
        this.myResourceModifiedMessagePersistenceSvc.persist(theResourceModifiedMessage);
    }

    protected ResourceModifiedMessage createResourceModifiedMessage(IBaseResource theNewResource, BaseResourceMessage.OperationTypeEnum theOperationType, RequestDetails theRequest) {
        RequestPartitionId requestPartitionId = this.myRequestPartitionHelperSvc.determineReadPartitionForRequestForRead(theRequest, theNewResource.getIdElement());
        return new ResourceModifiedMessage(this.myFhirContext, theNewResource, theOperationType, theRequest, requestPartitionId);
    }

    private boolean isSameResourceVersion(IBaseResource theOldResource, IBaseResource theNewResource) {
        if (Objects.isNull(theOldResource) || Objects.isNull(theNewResource)) {
            return false;
        }
        String oldVersion = theOldResource.getIdElement().getVersionIdPart();
        String newVersion = theNewResource.getIdElement().getVersionIdPart();
        if (StringUtils.isBlank((CharSequence)oldVersion) || StringUtils.isBlank((CharSequence)newVersion)) {
            return false;
        }
        return oldVersion.equals(newVersion);
    }

    public void setFhirContext(FhirContext theCtx) {
        this.myFhirContext = theCtx;
    }
}

