/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.submit.interceptor;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.SubscriptionMatchingStrategy;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.SubscriptionStrategyEvaluator;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionCriteriaParser;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import org.apache.commons.lang3.StringUtils;

public class SubscriptionQueryValidator {
    private final DaoRegistry myDaoRegistry;
    private final SubscriptionStrategyEvaluator mySubscriptionStrategyEvaluator;

    public SubscriptionQueryValidator(DaoRegistry theDaoRegistry, SubscriptionStrategyEvaluator theSubscriptionStrategyEvaluator) {
        this.myDaoRegistry = theDaoRegistry;
        this.mySubscriptionStrategyEvaluator = theSubscriptionStrategyEvaluator;
    }

    public void validateCriteria(String theCriteria, String theFieldName) {
        if (StringUtils.isBlank((CharSequence)theCriteria)) {
            throw new UnprocessableEntityException(Msg.code((int)11) + theFieldName + " must be populated");
        }
        SubscriptionCriteriaParser.SubscriptionCriteria parsedCriteria = SubscriptionCriteriaParser.parse(theCriteria);
        if (parsedCriteria == null) {
            throw new UnprocessableEntityException(Msg.code((int)12) + theFieldName + " can not be parsed");
        }
        if (parsedCriteria.getType() == SubscriptionCriteriaParser.TypeEnum.STARTYPE_EXPRESSION) {
            return;
        }
        for (String next : parsedCriteria.getApplicableResourceTypes()) {
            if (this.myDaoRegistry.isResourceTypeSupported(next)) continue;
            throw new UnprocessableEntityException(Msg.code((int)13) + theFieldName + " contains invalid/unsupported resource type: " + next);
        }
        if (parsedCriteria.getType() != SubscriptionCriteriaParser.TypeEnum.SEARCH_EXPRESSION) {
            return;
        }
        int sep = theCriteria.indexOf(63);
        if (sep <= 1) {
            throw new UnprocessableEntityException(Msg.code((int)14) + theFieldName + " must be in the form \"{Resource Type}?[params]\"");
        }
        String resType = theCriteria.substring(0, sep);
        if (resType.contains("/")) {
            throw new UnprocessableEntityException(Msg.code((int)15) + theFieldName + " must be in the form \"{Resource Type}?[params]\"");
        }
    }

    public SubscriptionMatchingStrategy determineStrategy(String theCriteriaString) {
        return this.mySubscriptionStrategyEvaluator.determineStrategy(theCriteriaString);
    }
}

