/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.submit.interceptor;

import ca.uhn.fhir.interceptor.api.IInterceptorService;
import ca.uhn.fhir.jpa.model.config.SubscriptionSettings;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.SubscriptionMatcherInterceptor;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.SubscriptionValidatingInterceptor;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicValidatingInterceptor;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionSubmitInterceptorLoader {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionSubmitInterceptorLoader.class);
    @Nonnull
    private IInterceptorService myInterceptorService;
    @Nonnull
    private final SubscriptionSettings mySubscriptionSettings;
    @Nonnull
    private final SubscriptionMatcherInterceptor mySubscriptionMatcherInterceptor;
    @Nonnull
    private final SubscriptionValidatingInterceptor mySubscriptionValidatingInterceptor;
    @Nullable
    private final SubscriptionTopicValidatingInterceptor mySubscriptionTopicValidatingInterceptor;
    private boolean mySubscriptionValidatingInterceptorRegistered;
    private boolean mySubscriptionMatcherInterceptorRegistered;
    private boolean mySubscriptionTopicValidatingInterceptorRegistered;

    public SubscriptionSubmitInterceptorLoader(@Nonnull IInterceptorService theInterceptorService, @Nonnull SubscriptionSettings theSubscriptionSettings, @Nonnull SubscriptionMatcherInterceptor theSubscriptionMatcherInterceptor, @Nonnull SubscriptionValidatingInterceptor theSubscriptionValidatingInterceptor, @Nullable SubscriptionTopicValidatingInterceptor theSubscriptionTopicValidatingInterceptor) {
        this.setInterceptorService(theInterceptorService);
        this.mySubscriptionSettings = theSubscriptionSettings;
        this.mySubscriptionMatcherInterceptor = theSubscriptionMatcherInterceptor;
        this.mySubscriptionValidatingInterceptor = theSubscriptionValidatingInterceptor;
        this.mySubscriptionTopicValidatingInterceptor = theSubscriptionTopicValidatingInterceptor;
    }

    @PostConstruct
    public void start() {
        Set supportedSubscriptionTypes = this.mySubscriptionSettings.getSupportedSubscriptionTypes();
        if (supportedSubscriptionTypes.isEmpty()) {
            ourLog.info("Subscriptions are disabled on this server.  Subscriptions will not be activated and incoming resources will not be matched against subscriptions.");
        } else if (!this.mySubscriptionMatcherInterceptorRegistered) {
            ourLog.info("Registering subscription matcher interceptor");
            this.myInterceptorService.registerInterceptor((Object)this.mySubscriptionMatcherInterceptor);
            this.mySubscriptionMatcherInterceptorRegistered = true;
        }
        if (!this.mySubscriptionValidatingInterceptorRegistered) {
            this.myInterceptorService.registerInterceptor((Object)this.mySubscriptionValidatingInterceptor);
            this.mySubscriptionValidatingInterceptorRegistered = true;
        }
        if (this.mySubscriptionTopicValidatingInterceptor != null && !this.mySubscriptionTopicValidatingInterceptorRegistered) {
            this.myInterceptorService.registerInterceptor((Object)this.mySubscriptionTopicValidatingInterceptor);
            this.mySubscriptionTopicValidatingInterceptorRegistered = true;
        }
    }

    protected void setInterceptorService(IInterceptorService theInterceptorService) {
        this.myInterceptorService = theInterceptorService;
    }

    protected IInterceptorService getInterceptorService() {
        return this.myInterceptorService;
    }

    @VisibleForTesting
    public void unregisterInterceptorsForUnitTest() {
        this.myInterceptorService.unregisterInterceptor((Object)this.mySubscriptionMatcherInterceptor);
        this.myInterceptorService.unregisterInterceptor((Object)this.mySubscriptionValidatingInterceptor);
        this.mySubscriptionValidatingInterceptorRegistered = false;
        this.mySubscriptionMatcherInterceptorRegistered = false;
    }
}

