/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.submit.interceptor;

import ca.uhn.fhir.jpa.subscription.channel.api.PayloadTooLargeException;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.IResourceModifiedConsumer;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.SubscriptionMatcherInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SynchronousSubscriptionMatcherInterceptor
extends SubscriptionMatcherInterceptor {
    @Autowired
    private IResourceModifiedConsumer myResourceModifiedConsumer;

    @Override
    protected void processResourceModifiedMessage(final ResourceModifiedMessage theResourceModifiedMessage) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public int getOrder() {
                    return 0;
                }

                public void afterCommit() {
                    SynchronousSubscriptionMatcherInterceptor.this.doSubmitResourceModified(theResourceModifiedMessage);
                }
            });
        } else {
            this.doSubmitResourceModified(theResourceModifiedMessage);
        }
    }

    private void doSubmitResourceModified(ResourceModifiedMessage theResourceModifiedMessage) {
        block2: {
            try {
                this.myResourceModifiedConsumer.submitResourceModified(theResourceModifiedMessage);
            }
            catch (MessageDeliveryException e) {
                if (!(e.getCause() instanceof PayloadTooLargeException)) break block2;
                theResourceModifiedMessage.setPayloadToNull();
                this.myResourceModifiedConsumer.submitResourceModified(theResourceModifiedMessage);
            }
        }
    }
}

