/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.topic;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_43_50;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4b.model.Resource;
import org.hl7.fhir.r4b.model.SubscriptionTopic;

public final class SubscriptionTopicCanonicalizer {
    private static final FhirContext ourFhirContextR5 = FhirContext.forR5();

    private SubscriptionTopicCanonicalizer() {
    }

    public static org.hl7.fhir.r5.model.SubscriptionTopic canonicalizeTopic(FhirContext theFhirContext, IBaseResource theSubscriptionTopic) {
        switch (theFhirContext.getVersion().getVersion()) {
            case R4B: {
                return (org.hl7.fhir.r5.model.SubscriptionTopic)VersionConvertorFactory_43_50.convertResource((Resource)((SubscriptionTopic)theSubscriptionTopic));
            }
            case R5: {
                return (org.hl7.fhir.r5.model.SubscriptionTopic)theSubscriptionTopic;
            }
        }
        throw new UnsupportedOperationException(Msg.code((int)2337) + "Subscription topics are not supported in FHIR version " + theFhirContext.getVersion().getVersion());
    }
}

