/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.topic;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionDeliveryRequest;
import ca.uhn.fhir.jpa.subscription.match.matcher.subscriber.SubscriptionMatchDeliverer;
import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionRegistry;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.CanonicalTopicSubscription;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicDispatchRequest;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicPayloadBuilder;
import ca.uhn.fhir.jpa.topic.filter.ISubscriptionTopicFilterMatcher;
import ca.uhn.fhir.jpa.topic.filter.SubscriptionTopicFilterUtil;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.util.Logs;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;

public class SubscriptionTopicDispatcher {
    private static final Logger ourLog = Logs.getSubscriptionTopicLog();
    private final FhirContext myFhirContext;
    private final SubscriptionRegistry mySubscriptionRegistry;
    private final SubscriptionMatchDeliverer mySubscriptionMatchDeliverer;
    private final SubscriptionTopicPayloadBuilder mySubscriptionTopicPayloadBuilder;

    public SubscriptionTopicDispatcher(FhirContext theFhirContext, SubscriptionRegistry theSubscriptionRegistry, SubscriptionMatchDeliverer theSubscriptionMatchDeliverer, SubscriptionTopicPayloadBuilder theSubscriptionTopicPayloadBuilder) {
        this.myFhirContext = theFhirContext;
        this.mySubscriptionRegistry = theSubscriptionRegistry;
        this.mySubscriptionMatchDeliverer = theSubscriptionMatchDeliverer;
        this.mySubscriptionTopicPayloadBuilder = theSubscriptionTopicPayloadBuilder;
    }

    public int dispatch(String theTopicUrl, List<IBaseResource> theResources, RestOperationTypeEnum theRequestType) {
        SubscriptionTopicDispatchRequest subscriptionTopicDispatchRequest = new SubscriptionTopicDispatchRequest(theTopicUrl, theResources, (f, r) -> InMemoryMatchResult.successfulMatch(), theRequestType, null, null, null);
        return this.dispatch(subscriptionTopicDispatchRequest);
    }

    public int dispatch(SubscriptionTopicDispatchRequest theSubscriptionTopicDispatchRequest) {
        int count = 0;
        List<ActiveSubscription> topicSubscriptions = this.mySubscriptionRegistry.getTopicSubscriptionsByTopic(theSubscriptionTopicDispatchRequest.getTopicUrl());
        if (!topicSubscriptions.isEmpty()) {
            for (ActiveSubscription activeSubscription : topicSubscriptions) {
                boolean success = this.matchFiltersAndDeliver(theSubscriptionTopicDispatchRequest, activeSubscription);
                if (!success) continue;
                ++count;
            }
        }
        return count;
    }

    private boolean matchFiltersAndDeliver(SubscriptionTopicDispatchRequest theSubscriptionTopicDispatchRequest, ActiveSubscription theActiveSubscription) {
        String topicUrl = theSubscriptionTopicDispatchRequest.getTopicUrl();
        List<IBaseResource> resources = theSubscriptionTopicDispatchRequest.getResources();
        ISubscriptionTopicFilterMatcher subscriptionTopicFilterMatcher = theSubscriptionTopicDispatchRequest.getSubscriptionTopicFilterMatcher();
        if (resources.size() > 0) {
            IBaseResource firstResource = resources.get(0);
            String resourceType = this.myFhirContext.getResourceType(firstResource);
            CanonicalSubscription subscription = theActiveSubscription.getSubscription();
            CanonicalTopicSubscription topicSubscription = subscription.getTopicSubscription();
            if (topicSubscription.hasFilters()) {
                ourLog.debug("Checking if resource {} matches {} subscription filters on {}", new Object[]{firstResource.getIdElement().toUnqualifiedVersionless().getValue(), topicSubscription.getFilters().size(), subscription.getIdElement(this.myFhirContext).toUnqualifiedVersionless().getValue()});
                if (!SubscriptionTopicFilterUtil.matchFilters(firstResource, resourceType, subscriptionTopicFilterMatcher, topicSubscription)) {
                    return false;
                }
            }
        }
        theActiveSubscription.incrementDeliveriesCount();
        IBaseBundle bundlePayload = this.mySubscriptionTopicPayloadBuilder.buildPayload(resources, theActiveSubscription, topicUrl, theSubscriptionTopicDispatchRequest.getRequestType());
        bundlePayload.setId(UUID.randomUUID().toString());
        SubscriptionDeliveryRequest subscriptionDeliveryRequest = new SubscriptionDeliveryRequest(bundlePayload, theActiveSubscription, theSubscriptionTopicDispatchRequest);
        return this.mySubscriptionMatchDeliverer.deliverPayload(subscriptionDeliveryRequest, theSubscriptionTopicDispatchRequest.getInMemoryMatchResult());
    }
}

