/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.topic;

import ca.uhn.fhir.cache.BaseResourceCacheSynchronizer;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicCanonicalizer;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicRegistry;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.Logs;
import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4b.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Enumerations;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SubscriptionTopicLoader
extends BaseResourceCacheSynchronizer {
    private static final Logger ourLog = Logs.getSubscriptionTopicLog();
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private SubscriptionTopicRegistry mySubscriptionTopicRegistry;
    @Autowired
    protected ISearchParamRegistry mySearchParamRegistry;

    public SubscriptionTopicLoader() {
        super("SubscriptionTopic");
    }

    public void registerListener() {
        if (!this.myFhirContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.R4B)) {
            return;
        }
        super.registerListener();
    }

    @Nonnull
    protected SearchParameterMap getSearchParameterMap() {
        SearchParameterMap map = new SearchParameterMap();
        if (this.mySearchParamRegistry.getActiveSearchParam("SubscriptionTopic", "status") != null) {
            map.add("status", (IQueryParameterType)new TokenParam(null, Enumerations.PublicationStatus.ACTIVE.toCode()));
        }
        map.setLoadSynchronousUpTo(Integer.valueOf(10000));
        return map;
    }

    protected void handleInit(List<IBaseResource> resourceList) {
        this.updateSubscriptionTopicRegistry(resourceList);
    }

    protected int syncResourcesIntoCache(List<IBaseResource> resourceList) {
        return this.updateSubscriptionTopicRegistry(resourceList);
    }

    private int updateSubscriptionTopicRegistry(List<IBaseResource> theResourceList) {
        HashSet<String> allIds = new HashSet<String>();
        int registeredCount = 0;
        for (IBaseResource resource : theResourceList) {
            String nextId = resource.getIdElement().getIdPart();
            allIds.add(nextId);
            boolean registered = this.mySubscriptionTopicRegistry.register(this.normalizeToR5(resource));
            if (!registered) continue;
            ++registeredCount;
        }
        this.mySubscriptionTopicRegistry.unregisterAllIdsNotInCollection(allIds);
        ourLog.debug("Finished sync subscription topics - registered {}", (Object)registeredCount);
        return registeredCount;
    }

    private org.hl7.fhir.r5.model.SubscriptionTopic normalizeToR5(IBaseResource theResource) {
        if (theResource instanceof org.hl7.fhir.r5.model.SubscriptionTopic) {
            return (org.hl7.fhir.r5.model.SubscriptionTopic)theResource;
        }
        if (theResource instanceof SubscriptionTopic) {
            return SubscriptionTopicCanonicalizer.canonicalizeTopic(this.myFhirContext, theResource);
        }
        throw new IllegalArgumentException(Msg.code((int)2332) + "Only R4B and R5 SubscriptionTopic is currently supported.  Found " + theResource.getClass());
    }
}

