/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.topic;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicDispatchRequest;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicDispatcher;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicMatcher;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicRegistry;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicSupport;
import ca.uhn.fhir.jpa.topic.filter.InMemoryTopicFilterMatcher;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.subscription.api.IResourceModifiedMessagePersistenceSvc;
import ca.uhn.fhir.util.Logs;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;

public class SubscriptionTopicMatchingSubscriber
implements MessageHandler {
    private static final Logger ourLog = Logs.getSubscriptionTopicLog();
    private final FhirContext myFhirContext;
    @Autowired
    SubscriptionTopicSupport mySubscriptionTopicSupport;
    @Autowired
    SubscriptionTopicRegistry mySubscriptionTopicRegistry;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private SubscriptionTopicDispatcher mySubscriptionTopicDispatcher;
    @Autowired
    private InMemoryTopicFilterMatcher myInMemoryTopicFilterMatcher;
    @Autowired
    private IResourceModifiedMessagePersistenceSvc myResourceModifiedMessagePersistenceSvc;
    private MemoryCacheService myMemoryCacheService;

    public SubscriptionTopicMatchingSubscriber(FhirContext theFhirContext, MemoryCacheService memoryCacheService) {
        this.myFhirContext = theFhirContext;
        this.myMemoryCacheService = memoryCacheService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(@Nonnull Message<?> theMessage) throws MessagingException {
        HookParams params;
        ourLog.trace("Handling resource modified message: {}", theMessage);
        if (!(theMessage instanceof ResourceModifiedJsonMessage)) {
            ourLog.warn("Unexpected message payload type: {}", theMessage);
            return;
        }
        ResourceModifiedMessage msg = ((ResourceModifiedJsonMessage)theMessage).getPayload();
        if (msg.getPayload(this.myFhirContext) == null) {
            Optional inflatedMsg = this.myResourceModifiedMessagePersistenceSvc.inflatePersistedResourceModifiedMessageOrNull(msg);
            if (inflatedMsg.isEmpty()) {
                return;
            }
            msg = (ResourceModifiedMessage)inflatedMsg.get();
        }
        if (!this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.SUBSCRIPTION_TOPIC_BEFORE_PERSISTED_RESOURCE_CHECKED, params = new HookParams().add(ResourceModifiedMessage.class, (Object)msg))) {
            return;
        }
        try {
            this.matchActiveSubscriptionTopicsAndDeliver(msg);
        }
        finally {
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.SUBSCRIPTION_TOPIC_AFTER_PERSISTED_RESOURCE_CHECKED, params);
        }
    }

    private void matchActiveSubscriptionTopicsAndDeliver(ResourceModifiedMessage theMsg) {
        Collection<SubscriptionTopic> topics = this.mySubscriptionTopicRegistry.getAll();
        for (SubscriptionTopic topic : topics) {
            SubscriptionTopicMatcher matcher = new SubscriptionTopicMatcher(this.mySubscriptionTopicSupport, topic, this.myMemoryCacheService);
            InMemoryMatchResult result = matcher.match(theMsg);
            if (!result.matched()) continue;
            int deliveries = this.deliverToTopicSubscriptions(theMsg, topic, result);
            ourLog.info("Matched topic {} to message {}.  Notifications sent to {} subscriptions for delivery.", new Object[]{topic.getUrl(), theMsg, deliveries});
        }
    }

    private int deliverToTopicSubscriptions(ResourceModifiedMessage theMsg, SubscriptionTopic theSubscriptionTopic, InMemoryMatchResult theInMemoryMatchResult) {
        String topicUrl = theSubscriptionTopic.getUrl();
        IBaseResource matchedResource = theMsg.getNewPayload(this.myFhirContext);
        List<IBaseResource> matchedResourceList = Collections.singletonList(matchedResource);
        RestOperationTypeEnum restOperationType = theMsg.getOperationType().asRestOperationType();
        return this.mySubscriptionTopicDispatcher.dispatch(new SubscriptionTopicDispatchRequest(topicUrl, matchedResourceList, this.myInMemoryTopicFilterMatcher, restOperationType, theInMemoryMatchResult, theMsg.getPartitionId(), theMsg.getTransactionId()));
    }
}

