/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.topic;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.topic.status.INotificationStatusBuilder;
import ca.uhn.fhir.jpa.topic.status.R4BNotificationStatusBuilder;
import ca.uhn.fhir.jpa.topic.status.R4NotificationStatusBuilder;
import ca.uhn.fhir.jpa.topic.status.R5NotificationStatusBuilder;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.util.BundleBuilder;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionTopicPayloadBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionTopicPayloadBuilder.class);
    private final FhirContext myFhirContext;
    private final FhirVersionEnum myFhirVersion;
    private final INotificationStatusBuilder<? extends IBaseResource> myNotificationStatusBuilder;

    public SubscriptionTopicPayloadBuilder(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
        this.myFhirVersion = this.myFhirContext.getVersion().getVersion();
        switch (this.myFhirVersion) {
            case R4: {
                this.myNotificationStatusBuilder = new R4NotificationStatusBuilder(this.myFhirContext);
                break;
            }
            case R4B: {
                this.myNotificationStatusBuilder = new R4BNotificationStatusBuilder(this.myFhirContext);
                break;
            }
            case R5: {
                this.myNotificationStatusBuilder = new R5NotificationStatusBuilder(this.myFhirContext);
                break;
            }
            default: {
                throw this.unsupportedFhirVersionException();
            }
        }
    }

    public IBaseBundle buildPayload(List<IBaseResource> theResources, ActiveSubscription theActiveSubscription, String theTopicUrl, RestOperationTypeEnum theRestOperationType) {
        BundleBuilder bundleBuilder = new BundleBuilder(this.myFhirContext);
        IBaseResource notificationStatus = this.myNotificationStatusBuilder.buildNotificationStatus(theResources, theActiveSubscription, theTopicUrl);
        bundleBuilder.addCollectionEntry(notificationStatus);
        this.addResources(theResources, theActiveSubscription.getSubscription(), theRestOperationType, bundleBuilder);
        this.setBundleType(bundleBuilder);
        IBaseBundle retval = bundleBuilder.getBundle();
        if (ourLog.isDebugEnabled()) {
            String bundle = this.myFhirContext.newJsonParser().setPrettyPrint(true).encodeResourceToString((IBaseResource)retval);
            ourLog.debug("Bundle: {}", (Object)bundle);
        }
        return retval;
    }

    private void addResources(List<IBaseResource> theResources, CanonicalSubscription theCanonicalSubscription, RestOperationTypeEnum theRestOperationType, BundleBuilder theBundleBuilder) {
        Subscription.SubscriptionPayloadContent content = (Subscription.SubscriptionPayloadContent)ObjectUtils.defaultIfNull((Object)theCanonicalSubscription.getContent(), (Object)Subscription.SubscriptionPayloadContent.FULLRESOURCE);
        switch (content) {
            case EMPTY: {
                break;
            }
            case IDONLY: {
                this.addIdOnly(theBundleBuilder, theResources, theRestOperationType);
                break;
            }
            case FULLRESOURCE: {
                this.addFullResources(theBundleBuilder, theResources, theRestOperationType);
            }
        }
    }

    private void addIdOnly(BundleBuilder bundleBuilder, List<IBaseResource> theResources, RestOperationTypeEnum theRestOperationType) {
        for (IBaseResource resource : theResources) {
            switch (theRestOperationType) {
                case CREATE: {
                    bundleBuilder.addTransactionCreateEntryIdOnly(resource);
                    break;
                }
                case UPDATE: {
                    bundleBuilder.addTransactionUpdateIdOnlyEntry(resource);
                    break;
                }
                case DELETE: {
                    bundleBuilder.addTransactionDeleteEntry(resource);
                }
            }
        }
    }

    private void addFullResources(BundleBuilder bundleBuilder, List<IBaseResource> theResources, RestOperationTypeEnum theRestOperationType) {
        for (IBaseResource resource : theResources) {
            switch (theRestOperationType) {
                case CREATE: {
                    bundleBuilder.addTransactionCreateEntry(resource);
                    break;
                }
                case UPDATE: {
                    bundleBuilder.addTransactionUpdateEntry(resource);
                    break;
                }
                case DELETE: {
                    bundleBuilder.addTransactionDeleteEntry(resource);
                }
            }
        }
    }

    private void setBundleType(BundleBuilder bundleBuilder) {
        switch (this.myFhirVersion) {
            case R4: 
            case R4B: {
                bundleBuilder.setType(Bundle.BundleType.HISTORY.toCode());
                break;
            }
            case R5: {
                bundleBuilder.setType(Bundle.BundleType.SUBSCRIPTIONNOTIFICATION.toCode());
                break;
            }
            default: {
                throw this.unsupportedFhirVersionException();
            }
        }
    }

    private IllegalStateException unsupportedFhirVersionException() {
        return new IllegalStateException(Msg.code((int)2331) + "SubscriptionTopic subscriptions are not supported on FHIR version: " + this.myFhirVersion);
    }
}

