/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.topic;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicCanonicalizer;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicRegistry;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.server.exceptions.ResourceGoneException;
import ca.uhn.fhir.util.Logs;
import jakarta.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;

public class SubscriptionTopicRegisteringSubscriber
implements MessageHandler {
    private static final Logger ourLog = Logs.getSubscriptionTopicLog();
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private SubscriptionTopicRegistry mySubscriptionTopicRegistry;
    @Autowired
    private DaoRegistry myDaoRegistry;

    public void handleMessage(@Nonnull Message<?> theMessage) throws MessagingException {
        IBaseResource payloadResource;
        if (!(theMessage instanceof ResourceModifiedJsonMessage)) {
            ourLog.warn("Received message of unexpected type on matching channel: {}", theMessage);
            return;
        }
        ResourceModifiedMessage payload = ((ResourceModifiedJsonMessage)theMessage).getPayload();
        if (!payload.hasPayloadType(this.myFhirContext, "SubscriptionTopic")) {
            return;
        }
        switch (payload.getOperationType()) {
            case MANUALLY_TRIGGERED: 
            case TRANSACTION: {
                return;
            }
        }
        IIdType payloadId = payload.getPayloadId(this.myFhirContext).toUnqualifiedVersionless();
        try {
            IFhirResourceDao subscriptionDao = this.myDaoRegistry.getResourceDao("SubscriptionTopic");
            RequestDetails systemRequestDetails = this.getPartitionAwareRequestDetails(payload);
            payloadResource = subscriptionDao.read(payloadId, systemRequestDetails);
            if (payloadResource == null) {
                payloadResource = payload.getPayload(this.myFhirContext);
            }
        }
        catch (ResourceGoneException e) {
            this.mySubscriptionTopicRegistry.unregister(payloadId.getIdPart());
            return;
        }
        SubscriptionTopic subscriptionTopic = SubscriptionTopicCanonicalizer.canonicalizeTopic(this.myFhirContext, payloadResource);
        if (subscriptionTopic.getStatus() == Enumerations.PublicationStatus.ACTIVE) {
            this.mySubscriptionTopicRegistry.register(subscriptionTopic);
        } else {
            this.mySubscriptionTopicRegistry.unregister(payloadId.getIdPart());
        }
    }

    private RequestDetails getPartitionAwareRequestDetails(ResourceModifiedMessage payload) {
        RequestPartitionId payloadPartitionId = payload.getPartitionId();
        if (payloadPartitionId == null || payloadPartitionId.isDefaultPartition()) {
            payloadPartitionId = RequestPartitionId.defaultPartition();
        }
        return new SystemRequestDetails().setRequestPartitionId(payloadPartitionId);
    }
}

