/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.topic;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.rest.server.messaging.BaseResourceMessage;
import ca.uhn.fhir.util.BundleUtil;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.model.BaseReference;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;

public class SubscriptionTopicUtil {
    public static boolean matches(BaseResourceMessage.OperationTypeEnum theOperationType, List<Enumeration<SubscriptionTopic.InteractionTrigger>> theSupportedInteractions) {
        for (Enumeration<SubscriptionTopic.InteractionTrigger> next : theSupportedInteractions) {
            if (next.getValue() == SubscriptionTopic.InteractionTrigger.CREATE && theOperationType == BaseResourceMessage.OperationTypeEnum.CREATE) {
                return true;
            }
            if (next.getValue() == SubscriptionTopic.InteractionTrigger.UPDATE && theOperationType == BaseResourceMessage.OperationTypeEnum.UPDATE) {
                return true;
            }
            if (next.getValue() != SubscriptionTopic.InteractionTrigger.DELETE || theOperationType != BaseResourceMessage.OperationTypeEnum.DELETE) continue;
            return true;
        }
        return false;
    }

    public static IBaseResource extractResourceFromBundle(FhirContext myFhirContext, IBaseBundle theBundle) {
        List resources = BundleUtil.toListOfResources((FhirContext)myFhirContext, (IBaseBundle)theBundle);
        return resources.stream().filter(SubscriptionStatus.class::isInstance).map(SubscriptionStatus.class::cast).flatMap(subscriptionStatus -> subscriptionStatus.getNotificationEvent().stream()).filter(SubscriptionStatus.SubscriptionStatusNotificationEventComponent::hasFocus).map(SubscriptionStatus.SubscriptionStatusNotificationEventComponent::getFocus).map(BaseReference::getResource).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static boolean isEmptyContentTopicSubscription(CanonicalSubscription theCanonicalSubscription) {
        return theCanonicalSubscription.isTopicSubscription() && Subscription.SubscriptionPayloadContent.EMPTY == theCanonicalSubscription.getTopicSubscription().getContent();
    }
}

