/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.topic;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.SubscriptionMatchingStrategy;
import ca.uhn.fhir.jpa.subscription.submit.interceptor.SubscriptionQueryValidator;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicCanonicalizer;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.util.Logs;
import com.google.common.annotations.VisibleForTesting;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.slf4j.Logger;

public class SubscriptionTopicValidatingInterceptor {
    private static final Logger ourLog = Logs.getSubscriptionTopicLog();
    private final FhirContext myFhirContext;
    private final SubscriptionQueryValidator mySubscriptionQueryValidator;

    public SubscriptionTopicValidatingInterceptor(FhirContext theFhirContext, SubscriptionQueryValidator theSubscriptionQueryValidator) {
        this.myFhirContext = theFhirContext;
        this.mySubscriptionQueryValidator = theSubscriptionQueryValidator;
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED)
    public void resourcePreCreate(IBaseResource theResource, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId) {
        this.validateSubmittedSubscriptionTopic(theResource, theRequestDetails, theRequestPartitionId, Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED);
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED)
    public void resourceUpdated(IBaseResource theOldResource, IBaseResource theResource, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId) {
        this.validateSubmittedSubscriptionTopic(theResource, theRequestDetails, theRequestPartitionId, Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED);
    }

    @VisibleForTesting
    void validateSubmittedSubscriptionTopic(IBaseResource theSubscription, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId, Pointcut thePointcut) {
        if (Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED != thePointcut && Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED != thePointcut) {
            throw new UnprocessableEntityException(Msg.code((int)2340) + "Expected Pointcut to be either STORAGE_PRESTORAGE_RESOURCE_CREATED or STORAGE_PRESTORAGE_RESOURCE_UPDATED but was: " + thePointcut);
        }
        if (!"SubscriptionTopic".equals(this.myFhirContext.getResourceType(theSubscription))) {
            return;
        }
        SubscriptionTopic subscriptionTopic = SubscriptionTopicCanonicalizer.canonicalizeTopic(this.myFhirContext, theSubscription);
        boolean finished = false;
        if (subscriptionTopic.getStatus() == null) {
            throw new UnprocessableEntityException(Msg.code((int)2338) + "Can not process submitted SubscriptionTopic - SubscriptionTopic.status must be populated on this server");
        }
        switch (subscriptionTopic.getStatus()) {
            case ACTIVE: {
                break;
            }
            default: {
                finished = true;
            }
        }
        if (!finished) {
            subscriptionTopic.getResourceTrigger().stream().forEach(t -> this.validateQueryCriteria(t.getQueryCriteria()));
        }
    }

    private void validateQueryCriteria(SubscriptionTopic.SubscriptionTopicResourceTriggerQueryCriteriaComponent theQueryCriteria) {
        if (theQueryCriteria.getPrevious() != null) {
            this.validateCriteria(theQueryCriteria.getPrevious(), "SubscriptionTopic.resourceTrigger.queryCriteria.previous");
        }
        if (theQueryCriteria.getCurrent() != null) {
            this.validateCriteria(theQueryCriteria.getCurrent(), "SubscriptionTopic.resourceTrigger.queryCriteria.current");
        }
    }

    public void validateCriteria(String theCriteria, String theFieldName) {
        try {
            this.mySubscriptionQueryValidator.validateCriteria(theCriteria, theFieldName);
            SubscriptionMatchingStrategy strategy = this.mySubscriptionQueryValidator.determineStrategy(theCriteria);
            if (strategy != SubscriptionMatchingStrategy.IN_MEMORY) {
                ourLog.warn("Warning: Query Criteria '{}' in {} cannot be evaluated in-memory", (Object)theCriteria, (Object)theFieldName);
            }
        }
        catch (DataFormatException | InvalidRequestException e) {
            throw new UnprocessableEntityException(Msg.code((int)2339) + "Invalid SubscriptionTopic criteria '" + theCriteria + "' in " + theFieldName + ": " + e.getMessage());
        }
    }
}

