/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.topic;

import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.fhirpath.IFhirPathEvaluationContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicSupport;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicUtil;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.server.messaging.BaseResourceMessage;
import ca.uhn.fhir.storage.PreviousVersionReader;
import ca.uhn.fhir.util.Logs;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;

public class SubscriptionTriggerMatcher {
    private static final Logger ourLog = Logs.getSubscriptionTopicLog();
    private final SubscriptionTopicSupport mySubscriptionTopicSupport;
    private final BaseResourceMessage.OperationTypeEnum myOperation;
    private final SubscriptionTopic.SubscriptionTopicResourceTriggerComponent myTrigger;
    private final String myResourceName;
    private final IBaseResource myResource;
    private final IFhirResourceDao myDao;
    private final PreviousVersionReader myPreviousVersionReader;
    private final SystemRequestDetails mySrd;
    private final MemoryCacheService myMemoryCacheService;

    public SubscriptionTriggerMatcher(SubscriptionTopicSupport theSubscriptionTopicSupport, ResourceModifiedMessage theMsg, SubscriptionTopic.SubscriptionTopicResourceTriggerComponent theTrigger, MemoryCacheService theMemoryCacheService) {
        this.mySubscriptionTopicSupport = theSubscriptionTopicSupport;
        this.myOperation = theMsg.getOperationType();
        this.myResource = theMsg.getPayload(theSubscriptionTopicSupport.getFhirContext());
        this.myResourceName = this.myResource.fhirType();
        this.myDao = this.mySubscriptionTopicSupport.getDaoRegistry().getResourceDao(this.myResourceName);
        this.myTrigger = theTrigger;
        this.myPreviousVersionReader = new PreviousVersionReader(this.myDao);
        this.mySrd = new SystemRequestDetails();
        this.myMemoryCacheService = theMemoryCacheService;
    }

    public InMemoryMatchResult match() {
        List supportedInteractions = this.myTrigger.getSupportedInteraction();
        if (SubscriptionTopicUtil.matches(this.myOperation, supportedInteractions)) {
            SubscriptionTopic.SubscriptionTopicResourceTriggerQueryCriteriaComponent queryCriteria = this.myTrigger.getQueryCriteria();
            String fhirPathCriteria = this.myTrigger.getFhirPathCriteria();
            return this.match(queryCriteria, fhirPathCriteria);
        }
        return InMemoryMatchResult.noMatch();
    }

    private InMemoryMatchResult match(SubscriptionTopic.SubscriptionTopicResourceTriggerQueryCriteriaComponent theQueryCriteria, String theFhirPathCriteria) {
        String previousCriteria = theQueryCriteria.getPrevious();
        String currentCriteria = theQueryCriteria.getCurrent();
        InMemoryMatchResult previousMatches = InMemoryMatchResult.fromBoolean((previousCriteria == null ? 1 : 0) != 0);
        InMemoryMatchResult currentMatches = InMemoryMatchResult.fromBoolean((currentCriteria == null ? 1 : 0) != 0);
        InMemoryMatchResult fhirPathCriteriaEvaluationResult = this.evaluateFhirPathCriteria(theFhirPathCriteria);
        if (currentCriteria != null) {
            currentMatches = this.matchResource(this.myResource, currentCriteria);
        }
        if (this.myOperation == BaseResourceMessage.OperationTypeEnum.CREATE) {
            return currentMatches;
        }
        if (previousCriteria != null && (this.myOperation == BaseResourceMessage.OperationTypeEnum.UPDATE || this.myOperation == BaseResourceMessage.OperationTypeEnum.DELETE)) {
            Optional oPreviousVersion = this.myPreviousVersionReader.readPreviousVersion(this.myResource);
            if (oPreviousVersion.isPresent()) {
                previousMatches = this.matchResource((IBaseResource)oPreviousVersion.get(), previousCriteria);
            } else {
                ourLog.warn("Resource {} has a version of 1, which should not be the case for a create or delete operation", (Object)this.myResource.getIdElement().toUnqualifiedVersionless());
            }
        }
        if (theQueryCriteria.getRequireBoth()) {
            return InMemoryMatchResult.and((InMemoryMatchResult)InMemoryMatchResult.and((InMemoryMatchResult)previousMatches, (InMemoryMatchResult)currentMatches), (InMemoryMatchResult)fhirPathCriteriaEvaluationResult);
        }
        return InMemoryMatchResult.and((InMemoryMatchResult)InMemoryMatchResult.or((InMemoryMatchResult)previousMatches, (InMemoryMatchResult)currentMatches), (InMemoryMatchResult)fhirPathCriteriaEvaluationResult);
    }

    private InMemoryMatchResult evaluateFhirPathCriteria(String theFhirPathCriteria) {
        if (!Strings.isNullOrEmpty((String)theFhirPathCriteria)) {
            IFhirPath fhirPathEngine = this.mySubscriptionTopicSupport.getFhirContext().newFhirPath();
            fhirPathEngine.setEvaluationContext(new IFhirPathEvaluationContext(){

                public List<IBase> resolveConstant(Object appContext, String name, boolean beforeContext) {
                    Optional previousResource;
                    if ("current".equalsIgnoreCase(name)) {
                        return List.of(SubscriptionTriggerMatcher.this.myResource);
                    }
                    if ("previous".equalsIgnoreCase(name) && (previousResource = SubscriptionTriggerMatcher.this.myPreviousVersionReader.readPreviousVersion(SubscriptionTriggerMatcher.this.myResource)).isPresent()) {
                        return List.of((IBase)previousResource.get());
                    }
                    return null;
                }
            });
            try {
                IFhirPath.IParsedExpression expression = (IFhirPath.IParsedExpression)this.myMemoryCacheService.get(MemoryCacheService.CacheEnum.FHIRPATH_EXPRESSION, (Object)theFhirPathCriteria, exp -> {
                    try {
                        return fhirPathEngine.parse(exp);
                    }
                    catch (FHIRException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(Msg.code((int)2534) + e.getMessage(), e);
                    }
                });
                List result = fhirPathEngine.evaluate((IBase)this.myResource, expression, IBase.class);
                return this.parseResult(theFhirPathCriteria, result);
            }
            catch (FHIRException fhirException) {
                ourLog.warn("Subscription topic {} has a fhirPathCriteria that is not valid: {}", new Object[]{this.myTrigger.getId(), theFhirPathCriteria, fhirException});
                return InMemoryMatchResult.unsupportedFromReason((String)fhirException.getMessage());
            }
        }
        return InMemoryMatchResult.fromBoolean((boolean)true);
    }

    private InMemoryMatchResult parseResult(String theFhirPathCriteria, List<IBase> result) {
        if (result == null) {
            return InMemoryMatchResult.unsupportedFromReason((String)MessageFormatter.format((String)"FhirPath evaluation criteria '{}' from Subscription topic: '{}' resulted in null results.", (Object)theFhirPathCriteria, (Object)this.myTrigger.getId()).getMessage());
        }
        if (result.size() != 1) {
            return InMemoryMatchResult.unsupportedFromReason((String)MessageFormatter.arrayFormat((String)"FhirPath evaluation criteria '{}' from Subscription topic: '{}' resulted in '{}' results. Expected 1.", (Object[])new String[]{theFhirPathCriteria, this.myTrigger.getId(), String.valueOf(result.size())}).getMessage());
        }
        if (!(result.get(0) instanceof BooleanType)) {
            return InMemoryMatchResult.unsupportedFromReason((String)MessageFormatter.arrayFormat((String)"FhirPath evaluation criteria '{}' from Subscription topic: '{}' resulted in a non-boolean result: '{}'", (Object[])new String[]{theFhirPathCriteria, this.myTrigger.getId(), result.get(0).getClass().getName()}).getMessage());
        }
        return InMemoryMatchResult.fromBoolean((boolean)((BooleanType)result.get(0)).booleanValue());
    }

    private InMemoryMatchResult matchResource(IBaseResource theResource, String theCriteria) {
        InMemoryMatchResult result = this.mySubscriptionTopicSupport.getSearchParamMatcher().match(theCriteria, theResource, (RequestDetails)this.mySrd);
        if (!result.supported()) {
            ourLog.warn("Subscription topic {} has a query criteria that is not supported in-memory: {}", (Object)this.myTrigger.getId(), (Object)theCriteria);
        }
        return result;
    }
}

