/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.topic.status;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.topic.SubscriptionTopicUtil;
import ca.uhn.fhir.jpa.topic.status.INotificationStatusBuilder;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Subscription;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r5.model.SubscriptionStatus;

public class R4NotificationStatusBuilder
implements INotificationStatusBuilder<Parameters> {
    private final FhirContext myFhirContext;

    public R4NotificationStatusBuilder(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    @Override
    public Parameters buildNotificationStatus(List<IBaseResource> theResources, ActiveSubscription theActiveSubscription, String theTopicUrl) {
        Long eventNumber = theActiveSubscription.getDeliveriesCount();
        CanonicalSubscription canonicalSubscription = theActiveSubscription.getSubscription();
        Parameters parameters = new Parameters();
        parameters.getMeta().addProfile("http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-subscription-status-r4");
        parameters.setId(UUID.randomUUID().toString());
        parameters.addParameter("subscription", (Type)new Reference(theActiveSubscription.getSubscription().getIdElement(this.myFhirContext)));
        parameters.addParameter("topic", (Type)new CanonicalType(theTopicUrl));
        parameters.addParameter("status", (Type)new CodeType(Subscription.SubscriptionStatus.ACTIVE.toCode()));
        parameters.addParameter("type", (Type)new CodeType(SubscriptionStatus.SubscriptionNotificationType.EVENTNOTIFICATION.toCode()));
        parameters.addParameter("events-since-subscription-start", eventNumber.toString());
        Parameters.ParametersParameterComponent notificationEvent = parameters.addParameter();
        notificationEvent.setName("notification-event");
        notificationEvent.addPart().setName("event-number").setValue((Type)new StringType(eventNumber.toString()));
        notificationEvent.addPart().setName("timestamp").setValue((Type)new DateType(new Date()));
        if (!theResources.isEmpty() && !SubscriptionTopicUtil.isEmptyContentTopicSubscription(canonicalSubscription)) {
            IBaseResource firstResource = theResources.get(0);
            Reference resourceReference = new Reference(firstResource.getIdElement().toUnqualifiedVersionless());
            notificationEvent.addPart().setName("focus").setValue((Type)resourceReference);
        }
        return parameters;
    }
}

