/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.subscription;

import ca.uhn.fhir.broker.api.ChannelConsumerSettings;
import ca.uhn.fhir.broker.api.ChannelProducerSettings;
import ca.uhn.fhir.broker.api.IChannelConsumer;
import ca.uhn.fhir.broker.api.IChannelProducer;
import ca.uhn.fhir.broker.api.IMessageListener;
import ca.uhn.fhir.broker.impl.MultiplexingListener;
import ca.uhn.fhir.jpa.subscription.api.ISubscriptionDeliveryValidator;
import ca.uhn.fhir.jpa.subscription.channel.models.ProducingChannelParameters;
import ca.uhn.fhir.jpa.subscription.channel.models.ReceivingChannelParameters;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionChannelFactory;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionConsumerCache;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionDeliveryListenerFactory;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionProducerCache;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionResourceDeliveryMessageConsumer;
import ca.uhn.fhir.jpa.subscription.channel.subscription.SubscriptionValidatingListener;
import ca.uhn.fhir.jpa.subscription.match.registry.ActiveSubscription;
import ca.uhn.fhir.jpa.subscription.match.registry.SubscriptionRegistry;
import ca.uhn.fhir.jpa.subscription.model.ChannelRetryConfiguration;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryMessage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SubscriptionChannelRegistry {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionRegistry.class);
    private final SubscriptionConsumerCache myDeliveryConsumerCache = new SubscriptionConsumerCache();
    private final SubscriptionProducerCache myDeliveryProducerCache = new SubscriptionProducerCache();
    private final Multimap<String, String> myActiveSubscriptionByChannelName = Multimaps.synchronizedMultimap((Multimap)MultimapBuilder.hashKeys().arrayListValues().build());
    @Autowired
    private SubscriptionDeliveryListenerFactory mySubscriptionDeliveryListenerFactory;
    @Autowired
    private SubscriptionChannelFactory mySubscriptionDeliveryChannelFactory;
    @Autowired
    private ISubscriptionDeliveryValidator mySubscriptionDeliveryValidator;

    public synchronized void add(ActiveSubscription theActiveSubscription) {
        String channelName = theActiveSubscription.getChannelName();
        ourLog.info("Adding subscription {} to channel {}", (Object)theActiveSubscription.getId(), (Object)channelName);
        this.myActiveSubscriptionByChannelName.put((Object)channelName, (Object)theActiveSubscription.getId());
        if (this.myDeliveryConsumerCache.containsKey(channelName)) {
            ourLog.info("Channel {} already exists.  Not creating.", (Object)channelName);
            return;
        }
        ChannelRetryConfiguration retryConfigParameters = theActiveSubscription.getRetryConfigurationParameters();
        ReceivingChannelParameters receivingParameters = new ReceivingChannelParameters(channelName);
        receivingParameters.setRetryConfiguration(retryConfigParameters);
        SubscriptionResourceDeliveryMessageConsumer subscriptionResourceDeliveryMessageConsumer = this.buildSubscriptionResourceDeliveryMessageConsumer(theActiveSubscription, receivingParameters);
        this.myDeliveryConsumerCache.put(channelName, subscriptionResourceDeliveryMessageConsumer);
        ProducingChannelParameters producingChannelParameters = new ProducingChannelParameters(channelName);
        producingChannelParameters.setRetryConfiguration(retryConfigParameters);
        IChannelProducer<ResourceDeliveryMessage> producer = this.newProducer(producingChannelParameters);
        this.myDeliveryProducerCache.put(channelName, producer);
    }

    @Nonnull
    private SubscriptionResourceDeliveryMessageConsumer buildSubscriptionResourceDeliveryMessageConsumer(ActiveSubscription theActiveSubscription, ReceivingChannelParameters receivingParameters) {
        MultiplexingListener multiplexingListener = new MultiplexingListener(ResourceDeliveryMessage.class);
        IChannelConsumer<ResourceDeliveryMessage> deliveryConsumer = this.newDeliveryConsumer((IMessageListener<ResourceDeliveryMessage>)multiplexingListener, receivingParameters);
        Optional<IMessageListener<ResourceDeliveryMessage>> oDeliveryListener = this.mySubscriptionDeliveryListenerFactory.createDeliveryListener(theActiveSubscription.getChannelType());
        SubscriptionResourceDeliveryMessageConsumer subscriptionResourceDeliveryMessageConsumer = new SubscriptionResourceDeliveryMessageConsumer(deliveryConsumer);
        SubscriptionValidatingListener subscriptionValidatingListener = new SubscriptionValidatingListener(this.mySubscriptionDeliveryValidator, (IIdType)theActiveSubscription.getIdDt());
        subscriptionResourceDeliveryMessageConsumer.addListener((IMessageListener<ResourceDeliveryMessage>)subscriptionValidatingListener);
        oDeliveryListener.ifPresent(subscriptionResourceDeliveryMessageConsumer::addListener);
        return subscriptionResourceDeliveryMessageConsumer;
    }

    protected IChannelConsumer<ResourceDeliveryMessage> newDeliveryConsumer(IMessageListener<ResourceDeliveryMessage> theListener, ReceivingChannelParameters theParameters) {
        ChannelConsumerSettings settings = new ChannelConsumerSettings();
        settings.setRetryConfiguration(theParameters.getRetryConfiguration());
        return this.mySubscriptionDeliveryChannelFactory.newDeliveryConsumer(theParameters.getChannelName(), theListener, settings);
    }

    protected IChannelProducer<ResourceDeliveryMessage> newProducer(ProducingChannelParameters theParameters) {
        ChannelProducerSettings settings = new ChannelProducerSettings();
        settings.setRetryConfiguration(theParameters.getRetryConfiguration());
        return this.mySubscriptionDeliveryChannelFactory.newDeliveryProducer(theParameters.getChannelName(), settings);
    }

    public void remove(ActiveSubscription theActiveSubscription) {
        String channelName = theActiveSubscription.getChannelName();
        ourLog.info("Removing subscription {} from channel {}", (Object)theActiveSubscription.getId(), (Object)channelName);
        boolean removed = this.myActiveSubscriptionByChannelName.remove((Object)channelName, (Object)theActiveSubscription.getId());
        if (!removed) {
            ourLog.warn("Failed to remove subscription {} from channel {}", (Object)theActiveSubscription.getId(), (Object)channelName);
        }
        if (!this.myActiveSubscriptionByChannelName.containsKey((Object)channelName)) {
            this.myDeliveryConsumerCache.closeAndRemove(channelName);
            this.myDeliveryProducerCache.closeAndRemove(channelName);
        }
    }

    public synchronized SubscriptionResourceDeliveryMessageConsumer getDeliveryConsumerWithListeners(String theChannelName) {
        return this.myDeliveryConsumerCache.get(theChannelName);
    }

    public synchronized IChannelProducer<ResourceDeliveryMessage> getDeliveryChannelProducer(String theChannelName) {
        return this.myDeliveryProducerCache.get(theChannelName);
    }

    public synchronized int size() {
        return this.myDeliveryConsumerCache.size();
    }

    @VisibleForTesting
    public void logForUnitTest() {
        this.myDeliveryConsumerCache.logForUnitTest();
    }
}

